/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// GLColorPropPane.cpp : Cve[V t@C

#include "stdafx.h"
#include "fugen.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "GLColorPropPane.h"
#include "Misc/UserPreference.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLColorPropPane _CAO

//	//{{AFX_DATA_INIT(CGLColorPropPane)
//	//}}AFX_DATA_INIT
//}
CGLColorPropPane::CGLColorPropPane(fugenDoc* pDoc)
	:CGLPropPane(pDoc){
		//{{AFX_DATA_INIT(CGLColorPropPane)
		//}}AFX_DATA_INIT
}
void CGLColorPropPane::DoDataExchange(CDataExchange* pDX)
{
	CGLPropPane::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGLColorPropPane)

	DDX_Control(pDX, IDC_BUTTON_PROP_COLOR_AXIS_X, m_btnAxisX);
	DDX_Control(pDX, IDC_BUTTON_PROP_COLOR_AXIS_Y, m_btnAxisY);
	DDX_Control(pDX, IDC_BUTTON_PROP_COLOR_AXIS_Z, m_btnAxisZ);
	DDX_Control(pDX, IDC_BUTTON_PROP_COLOR_GRID, m_btnGrid);
	DDX_Control(pDX, IDC_BUTTON_PROP_COLOR_BKGND, m_btnBkgnd);
	DDX_Control(pDX, IDC_BUTTON_PROP_COLOR_CURRENT, m_btnCurrent);
	DDX_Control(pDX, IDC_BUTTON_PROP_COLOR_OBJECT, m_btnObject);
	//}}AFX_DATA_MAP
}

void CGLColorPropPane::SetDefaultColor(bool bRedraw){

	OnReset();

	if(bRedraw){
		m_btnBkgnd.Invalidate();
		m_btnGrid.Invalidate();
		m_btnAxisX.Invalidate();
		m_btnAxisY.Invalidate();
		m_btnAxisZ.Invalidate();
		m_btnCurrent.Invalidate();
		m_btnObject.Invalidate();
		//m_btnLocked.Invalidate();
	}
}

void CGLColorPropPane::LoadUserProf(){
	UserPreference& pref = UserPreference::getInstance();

	m_btnBkgnd.SetColor(pref.GetIntValue(upv_Color_Viewport_BackGround,UserPreference::CurrentValue));
	m_btnGrid.SetColor(pref.GetIntValue(upv_Color_Viewport_Grid,UserPreference::CurrentValue));
	m_btnAxisX.SetColor(pref.GetIntValue(upv_Color_Viewport_GridX,UserPreference::CurrentValue));
	m_btnAxisY.SetColor(pref.GetIntValue(upv_Color_Viewport_GridY,UserPreference::CurrentValue));
	m_btnAxisZ.SetColor(pref.GetIntValue(upv_Color_Viewport_GridZ,UserPreference::CurrentValue));
	m_btnCurrent.SetColor(pref.GetIntValue(upv_Color_Viewport_Select,UserPreference::CurrentValue));
	m_btnObject.SetColor(pref.GetIntValue(upv_Color_Object_Default,UserPreference::CurrentValue));

	UpdateData(FALSE);
}

BOOL CGLColorPropPane::UpdateUserProf(){
	if(UpdateData()){
		UserPreference& pref = UserPreference::getInstance();

		pref.SetIntValue(upv_Color_Viewport_BackGround, m_btnBkgnd.GetColor());
		pref.SetIntValue(upv_Color_Viewport_Grid, m_btnGrid.GetColor());
		pref.SetIntValue(upv_Color_Viewport_GridX, m_btnAxisX.GetColor());
		pref.SetIntValue(upv_Color_Viewport_GridY, m_btnAxisY.GetColor());
		pref.SetIntValue(upv_Color_Viewport_GridZ, m_btnAxisZ.GetColor());
		pref.SetIntValue(upv_Color_Viewport_Select, m_btnCurrent.GetColor());
		pref.SetIntValue(upv_Color_Object_Default, m_btnObject.GetColor());
		return TRUE;
	}

	return FALSE;
}

void CGLColorPropPane::ResetToDefaultUserProf(){
	UserPreference& pref = UserPreference::getInstance();

	m_btnBkgnd.SetColor(pref.GetIntValue(upv_Color_Viewport_BackGround,UserPreference::DefaultValue));
	m_btnGrid.SetColor(pref.GetIntValue(upv_Color_Viewport_Grid,UserPreference::DefaultValue));
	m_btnAxisX.SetColor(pref.GetIntValue(upv_Color_Viewport_GridX,UserPreference::DefaultValue));
	m_btnAxisY.SetColor(pref.GetIntValue(upv_Color_Viewport_GridY,UserPreference::DefaultValue));
	m_btnAxisZ.SetColor(pref.GetIntValue(upv_Color_Viewport_GridZ,UserPreference::DefaultValue));
	m_btnCurrent.SetColor(pref.GetIntValue(upv_Color_Viewport_Select,UserPreference::DefaultValue));
	m_btnObject.SetColor(pref.GetIntValue(upv_Color_Object_Default,UserPreference::DefaultValue));

	UpdateData(FALSE);
}

void CGLColorPropPane::LoadDocContext(){
	ASSERT_VALID(m_pTargetDoc);

	MGContext* pCtx = m_pTargetDoc->context();
	ASSERT(pCtx);

	m_btnBkgnd.SetColor(ARGBtoCOLORREF(pCtx->Bcolor().get_colorAsUInt()));
	m_btnCurrent.SetColor(ARGBtoCOLORREF(pCtx->Hcolor().get_colorAsUInt()));
	m_btnObject.SetColor(ARGBtoCOLORREF(pCtx->Gcolor().get_colorAsUInt()));

	m_btnGrid.SetColor(ARGBtoCOLORREF(pCtx->gridColor().get_colorAsUInt()));
	m_btnAxisX.SetColor(ARGBtoCOLORREF(pCtx->axisXcolor().get_colorAsUInt()));
	m_btnAxisY.SetColor(ARGBtoCOLORREF(pCtx->axisYcolor().get_colorAsUInt()));
	m_btnAxisZ.SetColor(ARGBtoCOLORREF(pCtx->axisZcolor().get_colorAsUInt()));

	UpdateData(FALSE);
}

BOOL CGLColorPropPane::UpdateDocContext(){
	ASSERT_VALID(m_pTargetDoc);
	MGContext* pCtx = m_pTargetDoc->context();
	ASSERT(pCtx);

	if(UpdateData()){
		pCtx->set_Bcolor(FromCOLORREF(m_btnBkgnd.GetColor()));
		pCtx->set_Hcolor(FromCOLORREF(m_btnCurrent.GetColor()));
		pCtx->set_Gcolor(FromCOLORREF(m_btnObject.GetColor()));
		pCtx->set_gridColor(FromCOLORREF(m_btnGrid.GetColor()));
		pCtx->set_axisXcolor(FromCOLORREF(m_btnAxisX.GetColor()));
		pCtx->set_axisYcolor(FromCOLORREF(m_btnAxisY.GetColor()));
		pCtx->set_axisZcolor(FromCOLORREF(m_btnAxisZ.GetColor()));

		m_pTargetDoc->apply_view_context_colors();
		return TRUE;
	}
	return FALSE;
}

void CGLColorPropPane::ResetToDefaultDocContext(){
	LoadUserProf();
}

BEGIN_MESSAGE_MAP(CGLColorPropPane, CGLPropPane)
	//{{AFX_MSG_MAP(CGLColorPropPane)
	ON_BN_CLICKED(IDC_BUTTON_PROP_COLOR_DEFAULT, OnButtonPropColorDefault)
	ON_BN_CLICKED(IDC_BUTTON_PROP_COLOR_BKGND, OnButtonPropColorBkgnd)
	ON_BN_CLICKED(IDC_BUTTON_PROP_COLOR_GRID, OnButtonPropColorGrid)
	ON_BN_CLICKED(IDC_BUTTON_PROP_COLOR_AXIS_X, OnButtonPropColorAxisX)
	ON_BN_CLICKED(IDC_BUTTON_PROP_COLOR_AXIS_Y, OnButtonPropColorAxisY)
	ON_BN_CLICKED(IDC_BUTTON_PROP_COLOR_AXIS_Z, OnButtonPropColorAxisZ)
	ON_BN_CLICKED(IDC_BUTTON_PROP_COLOR_CURRENT, OnButtonPropColorCurrent)
	ON_BN_CLICKED(IDC_BUTTON_PROP_COLOR_OBJECT, OnButtonPropColorObject)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGLColorPropPane bZ[W nh

void CGLColorPropPane::OnButtonPropColorDefault(){
	SetDefaultColor(true);
}

void CGLColorPropPane::OnButtonPropColorBkgnd()
{
	m_btnBkgnd.ChangeColor();
}

void CGLColorPropPane::OnButtonPropColorGrid(){
	m_btnGrid.ChangeColor();
}

void CGLColorPropPane::OnButtonPropColorAxisX(){
	m_btnAxisX.ChangeColor();
}

void CGLColorPropPane::OnButtonPropColorAxisY(){
	m_btnAxisY.ChangeColor();
}

void CGLColorPropPane::OnButtonPropColorAxisZ(){
	m_btnAxisZ.ChangeColor();
}

void CGLColorPropPane::OnButtonPropColorCurrent(){
	m_btnCurrent.ChangeColor();
}

void CGLColorPropPane::OnButtonPropColorObject(){
	m_btnObject.ChangeColor();
}
