#include "stdafx.h"
#include "GLColorComboBox.h"

#include "mgGL/Color.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CGLColorComboBox
CGLColorComboBox::CGLColorComboBox():CComboBox()
,m_dwColorOther(MGColor::get_ARGBinstance(MGColor::White))
,m_otherColorIdx(-1)
{
}

CGLColorComboBox::~CGLColorComboBox(){
}

int CGLColorComboBox::CompareItem(LPCOMPAREITEMSTRUCT){
	// Not sort.
	return 0;
}

void CGLColorComboBox::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct){
	CDC dc;
	dc.Attach(lpDrawItemStruct->hDC);
	CRect rc(lpDrawItemStruct->rcItem);
	
	bool bSelected = lpDrawItemStruct->itemState & ODS_SELECTED;

	if(LOWORD(lpDrawItemStruct->itemID) == (WORD)-1)
		bSelected = false;

	CRect rcMini(rc.left, rc.top, rc.left+16, rc.top + 16); // button rect
	rcMini.OffsetRect(0, (rc.Height() - rcMini.Height()) / 2);

	// color area
	// DWORD_PTRŕԋp̂ŁAIɌ^LXg
	DWORD dwColor = (DWORD)GetItemData(lpDrawItemStruct->itemID);
	
	COLORREF saved = dc.GetBkColor();
	dc.FillSolidRect(rcMini, ARGBtoCOLORREF(dwColor));
	dc.SetBkColor(saved);

	if(bSelected){
		dc.DrawEdge(rcMini, BDR_RAISEDINNER, BF_RECT);
	}

	rc.left += rcMini.Width() + 2;
	// draw item text

	COLORREF clBG = bSelected ? ::GetSysColor(COLOR_HIGHLIGHT) : RGB(255, 255, 255);
	if(bSelected || lpDrawItemStruct->itemAction == ODA_SELECT){
		COLORREF saved = dc.GetBkColor();
		dc.FillSolidRect(rc, clBG);
		dc.SetBkColor(saved);
	}

	// calc text rectangle and colors
	dc.SetBkMode(TRANSPARENT);
	COLORREF colorText = ::GetSysColor(bSelected ? COLOR_HIGHLIGHTTEXT : COLOR_MENUTEXT);
	saved = dc.GetBkColor();
	dc.FillSolidRect(rc, clBG);
	dc.SetBkColor(saved);

	CString str;
	GetLBText(lpDrawItemStruct->itemID, str);
	dc.SetTextColor(colorText);
	dc.DrawText(str, rc, DT_SINGLELINE | DT_VCENTER | DT_LEFT);
	dc.Detach();
}

void CGLColorComboBox::MeasureItem(LPMEASUREITEMSTRUCT)
{
}

/// Functions.

void CGLColorComboBox::InitItems(int otherColorARGB){

	InitStorage(8, 16);
	CString str;

	int idx = -1;
	VERIFY(str.LoadString(IDS_COLOR_BLACK));
	idx = AddString(str);
	VERIFY(idx>LB_ERR);
	SetItemData(idx, MGColor::get_ARGBinstance(MGColor::Black));

	VERIFY(str.LoadString(IDS_COLOR_RED));
	idx = AddString(str);
	VERIFY(idx>LB_ERR);
	SetItemData(idx, MGColor::get_ARGBinstance(MGColor::Red));

	VERIFY(str.LoadString(IDS_COLOR_GREEN));
	idx = AddString(str);
	VERIFY(idx>LB_ERR);
	SetItemData(idx, MGColor::get_ARGBinstance(MGColor::Green));

	VERIFY(str.LoadString(IDS_COLOR_BLUE));
	idx = AddString(str);
	VERIFY(idx>LB_ERR);
	SetItemData(idx, MGColor::get_ARGBinstance(MGColor::Blue));

	VERIFY(str.LoadString(IDS_COLOR_YELLOW));
	idx = AddString(str);
	VERIFY(idx>LB_ERR);
	SetItemData(idx, MGColor::get_ARGBinstance(MGColor::Yellow));

	VERIFY(str.LoadString(IDS_COLOR_MAGENTA));
	idx = AddString(str);
	VERIFY(idx>LB_ERR);
	SetItemData(idx, MGColor::get_ARGBinstance(MGColor::Magenta));

	VERIFY(str.LoadString(IDS_COLOR_CYAN));
	idx = AddString(str);
	VERIFY(idx>LB_ERR);
	SetItemData(idx, MGColor::get_ARGBinstance(MGColor::Cyan));

	VERIFY(str.LoadString(IDS_COLOR_WHITE));
	idx = AddString(str);
	VERIFY(idx>LB_ERR);
	SetItemData(idx, MGColor::get_ARGBinstance(MGColor::White));

	VERIFY(str.LoadString(IDS_COLOR_OTHER));
	idx = AddString(str);
	VERIFY(idx>LB_ERR);
	SetItemData(idx, m_dwColorOther);

	m_otherColorIdx = idx;
}

void CGLColorComboBox::setSelectedColorARGB(int colorARGB){
//	int colorIdx = 

}

// ݑIĂFARGBl擾
int CGLColorComboBox::getSelectedColorARGB(){
	return 0;
}

// I𒆂̐FCOLORREFŎ擾
COLORREF CGLColorComboBox::getSelectedColor(){
	return 0;
}
