/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno             */
/* All rights reserved.                                             */
/********************************************************************/

// GLGridPropPane.cpp : Cve[V t@C

#include "stdafx.h"
#include "mgGL/ConstructionPlane.h"
#include "fugen.h"
#include "fugenView.h"
#include "fugenView2D.h"
#include "IO/util.h"
#include "ViewCmd/CPlaneUtil.h"
#include "GLCPlanePropPane.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLCPlanePropPane _CAO

CGLCPlanePropPane::CGLCPlanePropPane(fugenDoc* pDoc)
	:CGLPropPane(pDoc),m_dirty(false),m_targetView(pDoc->get_main_view()){
}

void CGLCPlanePropPane::DoDataExchange(CDataExchange* pDX){
	CGLPropPane::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGLCPlanePropPane)
	DDX_Text(pDX, IDC_EDIT_GRID_MINORX, m_dGridMinor[0]);
	DDX_Text(pDX, IDC_EDIT_GRID_MINORY, m_dGridMinor[1]);
	DDX_Text(pDX, IDC_EDIT_GRID_NUMX, m_nGrid[0]);
	DDX_Text(pDX, IDC_EDIT_GRID_NUMY, m_nGrid[1]);
	DDX_Text(pDX, IDC_CPLANE_ORIGIN, m_CPlaneOrigin);
	DDX_Text(pDX, IDC_CPLANE_XDIRECTION, m_CPlaneXAxis);
	DDX_Text(pDX, IDC_CPLANE_YDIRECTION, m_CPlaneYAxis);
	//}}AFX_DATA_MAP

	DDV_PositiveDouble(pDX, m_dGridMinor[0]);
	DDV_PositiveDouble(pDX, m_dGridMinor[1]);
	DDV_PositiveDouble(pDX, m_nGrid[0]); // ̐ǁADoubleőp
	DDV_PositiveDouble(pDX, m_nGrid[1]);
}

BEGIN_MESSAGE_MAP(CGLCPlanePropPane, CGLPropPane)
	//{{AFX_MSG_MAP(CGLCPlanePropPane)
	ON_BN_CLICKED(IDC_BUTTON_PROP_GRID_DEFAULT, OnButtonPropGridDefault)
	ON_BN_CLICKED(IDC_BUTTON_PROP_CPLANE_DEFAULT, &CGLCPlanePropPane::OnBnClickedButtonPropCplaneDefault)
	//}}AFX_MSG_MAP
	ON_EN_UPDATE(IDC_CPLANE_ORIGIN, &CGLCPlanePropPane::OnEnUpdateCplane)
	ON_EN_CHANGE(IDC_CPLANE_XDIRECTION, &CGLCPlanePropPane::OnEnUpdateCplane)
	ON_EN_CHANGE(IDC_CPLANE_YDIRECTION, &CGLCPlanePropPane::OnEnUpdateCplane)
END_MESSAGE_MAP()

void CGLCPlanePropPane::OnButtonPropGridDefault(){	
	if(m_pTargetDoc){
		ASSERT_VALID(m_pTargetDoc);
		double uspan,vspan,spanlen;
		int lnumu,lnumv;
		MGConstructionPlane cplane;
		cplane.setGridDataByBox(m_pTargetDoc->box());//Get the info by invoking MGConstructionPlane.
		cplane.get_grid_data(uspan,vspan,lnumu,lnumv,spanlen);

		m_nGrid[0] =lnumu; m_nGrid[1] = lnumv;
		m_dGridMinor[0]=uspan; m_dGridMinor[1] = vspan;
		UpdateData(FALSE);
		set_dirty();
	}
	Invalidate();
}

void CGLCPlanePropPane::LoadUserProf(){
}

BOOL CGLCPlanePropPane::UpdateUserProf(){
	return FALSE;
}

void CGLCPlanePropPane::ResetToDefaultUserProf(){
}

void CGLCPlanePropPane::LoadDocContext(){
	ASSERT_VALID(m_pTargetDoc);

	m_targetView=theApp.currentfugenView(m_pTargetDoc);
	CString viewName=m_targetView->viewTitle();
	SetDlgItemText(IDC_CPLANEPANE_TITLE,viewName);

	const MGConstructionPlane& cpl=m_targetView->cplane();
	double nspan;

	// Obh̖{A׃ObhԊu擾
	cpl.get_grid_data(m_dGridMinor[0],m_dGridMinor[1],m_nGrid[0],m_nGrid[1],nspan);

	//Set cplane's origin and X and Y axes strings to the dialog data.
	const MGPlane& cplane=cpl.plane();
	setCPlaneOriginAxesString(cplane);

	if(m_targetView->is_2D()){
		CWnd* xdirV=GetDlgItem(IDC_CPLANE_XDIRECTION);
		xdirV->EnableWindow(FALSE);
		CWnd* ydirV=GetDlgItem(IDC_CPLANE_YDIRECTION);
		ydirV->EnableWindow(FALSE);
	}
	UpdateData(FALSE);
}

BOOL CGLCPlanePropPane::UpdateDocContext(){
	ASSERT_VALID(m_pTargetDoc);

	if(m_dirty){
		//Set cplane's origin and X and Y axes strings to the dialog data.
		const MGPlane& cplane=m_targetView->cplane().plane();

		MGVector uderi,vderi, w;
		StringVectorConvert(m_CPlaneOrigin,w);
		MGPosition origin(w);

		StringVectorConvert(m_CPlaneXAxis,uderi);
		StringVectorConvert(m_CPlaneYAxis,vderi);
		MGUnit_vector ud(uderi), vd, normal;
		ud.orthonormal(vderi,vd,normal);

		ExecPlaneAction(m_targetView, ud,vd,origin);
		setCPlaneOriginAxesString(cplane);
		set_dirty(false);
	}
	UpdateData(FALSE);
	return TRUE;
}

void CGLCPlanePropPane::ResetToDefaultDocContext(){
	UpdateData(FALSE);
}

//Set the (x,y,z) string of the origin , X axis, and Y axis of the cplane into members.
void CGLCPlanePropPane::setCPlaneOriginAxesString(const MGPlane& cplane){
	CString conversionForm;
	VERIFY(conversionForm.LoadString(IDS_FORMAT_COORD_3D));
	
	//Origin
	const MGPosition& origin=cplane.center();
	m_CPlaneOrigin.Format(conversionForm, origin[0], origin[1], origin[2]);
	
	//X axis
	const MGVector& xdir=cplane.u_deriv();
	m_CPlaneXAxis.Format(conversionForm, xdir[0], xdir[1], xdir[2]);
	
	//Y axis
	const MGVector& ydir=cplane.v_deriv();
	m_CPlaneYAxis.Format(conversionForm, ydir[0], ydir[1], ydir[2]);
}

void CGLCPlanePropPane::OnBnClickedButtonPropCplaneDefault(){
	if(m_pTargetDoc){
		ASSERT_VALID(m_pTargetDoc);
		MGConstructionPlane cplane;
		cplane.setGridDataByBox(m_pTargetDoc->box());//Get the info by invoking MGConstructionPlane.
		setCPlaneOriginAxesString(cplane.plane());
		UpdateData(FALSE);
		set_dirty();
	}
	Invalidate();
}

void CGLCPlanePropPane::OnEnUpdateCplane(){
	set_dirty();
}
