/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file GLBlendDlg.h
 * @brief NX CGLBlendDlg ̎
 */
#if !defined(AFX_GLBLENDDLG_H__CC71B898_0E05_426C_9C6B_E25A0B300C16__INCLUDED_)
#define AFX_GLBLENDDLG_H__CC71B898_0E05_426C_9C6B_E25A0B300C16__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mgModelessDialogue.h"

class MGSurfBlendAcrossTool;

/////////////////////////////////////////////////////////////////////////////
// CGLBlendDlg _CAO

class CGLBlendDlg : public mgModelessDialogue{
	friend class MGSurfBlendAcrossTool;

	// _CAO f[^
		//{{AFX_DATA(CGLBlendDlg)
	bool& m_continuous;
	double* m_mag; //Magnitude of the starting and ending 1st derivative.
	int		m_slider_ue;
	int		m_slider_us;
	//}}AFX_DATA

	// Controls the continuity to side edges.
	bool                  m_bModified;
	CButton m_continuousEdge;

public:
	CGLBlendDlg(double mag[2], bool& continuous, MGSurfBlendAcrossTool* tool);   // W̃RXgN^


// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CGLBlendDlg)
public:
	virtual void OnOK();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	void UpdateView();
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:

	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CGLBlendDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnUpdateEdit();
	afx_msg void OnKillfocusEdit();
	afx_msg void OnBnClickedContinuousEdge();
	//}}AFX_MSG


	MGSurfBlendAcrossTool * getSurfBlendAcrossToolPointer();

	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_GLBLENDDLG_H__CC71B898_0E05_426C_9C6B_E25A0B300C16__INCLUDED_)
