/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file GLAttribSheet.cpp
 * @brief NX CGLAttribSheet ̎
 */
#include "stdafx.h"
#include "fugen.h"
#include "fugenDoc.h"

#include "Undo/MultiActions.h"
#include "Undo/GelAttribUpdateAction.h"
#include "GLAttribSheet.h"

#include "mgGL/Color.h"
#include "mgGL/LineStipple.h"
#include "mgGL/LineWidth.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLAttribSheet

IMPLEMENT_DYNAMIC(CGLAttribSheet, CPropertySheet)

CGLAttribSheet::CGLAttribSheet(UINT nIDCaption, CWnd* pParentWnd, UINT iSelectPage)
: CPropertySheet(nIDCaption, pParentWnd, iSelectPage){
	InitContents();
}

CGLAttribSheet::CGLAttribSheet(LPCTSTR pszCaption, CWnd* pParentWnd, UINT iSelectPage)
: CPropertySheet(pszCaption, pParentWnd, iSelectPage){
	InitContents();
}

CGLAttribSheet::~CGLAttribSheet(){
}

void CGLAttribSheet::InitContents(){
	m_psh.dwFlags |= PSH_NOAPPLYNOW;
	m_psh.dwFlags ^= PSH_HASHELP;

	m_pageColorLine.m_psp.dwFlags ^= PSP_HASHELP;
	AddPage(&m_pageColorLine);
}

/// 
void CGLAttribSheet::InitAttrib(const MGPickObjects& objs, fugenDoc* pDoc){
	m_pageColorLine.InitAttrib(objs, pDoc);
}

void CGLAttribSheet::ModifyAttrib(MGPickObject& target, fugenDoc* pDoc) const
{
	ModifyAttrib(MGPickObjects(target), pDoc);
}

void CGLAttribSheet::ModifyAttrib(MGPickObjects& objs, fugenDoc* pDoc) const{
	CMultiActions* macts=new CMultiActions;
	UniqueGLAttribVec attrs;
	//F
	if(m_pageColorLine.context_color() == BST_CHECKED){
		macts->push_back(new CGelAttribUpdateAction(pDoc,objs,MGCOLOR_TID));
	}else if(m_pageColorLine.context_color() == BST_UNCHECKED){
		attrs.emplace_back(m_pageColorLine.CreateColor());
	}
	//
	if(m_pageColorLine.context_line_width() == BST_CHECKED){
		macts->push_back(new CGelAttribUpdateAction(pDoc,objs,MGLINE_WIDTH_TID));
	}else if(m_pageColorLine.context_line_width() == BST_UNCHECKED){
		MGLineWidth* lw = m_pageColorLine.CreateLineWidth();
		lw->enabled() ? attrs.emplace_back(lw) : delete lw;
	}
	//
	if(m_pageColorLine.context_line_stipple() == BST_CHECKED){
		macts->push_back(new CGelAttribUpdateAction(pDoc,objs,MGLINE_STIPPLE_TID));
	}else if(m_pageColorLine.context_line_stipple() == BST_UNCHECKED){
		MGLineStipple* ls = m_pageColorLine.CreateLineStipple();
		ls->enabled() ? attrs.emplace_back(ls) : delete ls;
	}

	if(attrs.size())
		macts->push_back(new CGelAttribUpdateAction(pDoc,objs,std::move(attrs)));

	if(macts->empty())
		delete macts;
	else
		macts->Do();
}

BEGIN_MESSAGE_MAP(CGLAttribSheet, CPropertySheet)
	//{{AFX_MSG_MAP(CGLAttribSheet)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CGLAttribSheet::getAttrib(
	MGColor& color,
	MGLineWidth& lwidth,
	MGLineStipple& lstipple
)const{
	color = m_pageColorLine.GetColor();
	lwidth = m_pageColorLine.GetLineWidth();
	lstipple = m_pageColorLine.GetLineStipple();
}