/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file ExportTool.cpp
 * @brief ExportTool.h ̎
 */
#include "stdafx.h"
#include "FileCmd/ExportTool.h"
#include "fugenDoc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGExportTool

MGExportTool::MGExportTool(fugenDoc* pDoc)
	 : MGCommandStateOwner(pDoc, ID_FILE_EXPORT)
{
}

MGCommandBase* MGExportTool::initial_clone(fugenDoc* pDoc)const{
	return new MGExportTool(pDoc);
}

bool MGExportTool::initiate_tool(){
	MGCommandStateOwner::initiate_tool();

	// ɉIuWFNgIĂꍇ́A
	// CɃt@Cۑ_CAÕXebv܂ŃXLbvB
	const MGPickObjects& selection = current_objects();
	if(selection.empty()){
		set_child_current_command(new MGExportSelectState(this));
	}
	else{
		SetTarget(selection);
		set_child_current_command(new MGExportSaveState(this));
	}

	return false;
}

const MGPickObjects& MGExportTool::GetTarget() const
{
	return m_target;
}

void MGExportTool::SetTarget(const MGPickObjects& target)
{
	m_target = target;
}

// MGExportSelectState

MGExportSelectState::MGExportSelectState(MGExportTool* pOwnerTool)
	 : MGSelectState(pOwnerTool, MULTIPLE_SELECT)
{
}

bool MGExportSelectState::initiate_tool(){
	MGSelectState::initiate_tool();

	// ÔߑINAB
	clear_pick_object();

	SetStatusMessage(IDS_PROMPT_FILE_EXPORT_SEL);

	return false;
}

bool MGExportSelectState::OnKeyDown(fugenView* pView, UINT nChar,UINT nRepCnt, UINT nFlags)
{
	switch(nChar){
	case VK_RETURN:
		//  [S2] ֑JڂB
		state_owner()->SetTarget(current_objects());
		set_sibling_next_command(new MGExportSaveState(state_owner()));
		return false;
	default:;
	}
	return MGSelectState::OnKeyDown(pView, nChar, nRepCnt, nFlags);
}

// MGExportSaveState

MGExportSaveState::MGExportSaveState(MGExportTool* pOwnerTool)
	 : MGCommandBase(pOwnerTool)
{
}

bool MGExportSaveState::initiate_tool(){
	MGCommandBase::initiate_tool();
	MGExportTool* pOwner = state_owner();
	const MGPickObjects& target = pOwner->GetTarget();
	if(target.empty()){
		// LZƂ݂ȂB
		return pOwner->OnCommandEnd(3);
	}

	SetStatusMessage(IDS_PROMPT_FILE_EXPORT_PATH);

	return execute();
}

bool MGExportSaveState::execute(){
	MGExportTool* pOwner = state_owner();

	CString strPath;
	if(!::AfxGetApp()->DoPromptFileName(
		strPath, AFX_IDS_SAVEFILECOPY,
		OFN_HIDEREADONLY | OFN_PATHMUSTEXIST, FALSE,
		document()->GetDocTemplate()))
	{
		// LZ
		return pOwner->OnCommandEnd(3);
	}

	const int nRet = document()->ExportSelection(strPath, pOwner->GetTarget());

	CString str, strMsg;
	switch(nRet){
	case -1:
		strMsg.LoadString(IDS_FILE_EXPORT_UNKNOWN_FORMAT);
		str.Format(IDS_ERROR, strMsg);
		putInOutputWindow(str);
		return OnCommandEnd(2);
	case 0:
		// bZ[Wo͍ς
		return OnCommandEnd(2);
	default:
		strMsg.Format(IDS_FILE_EXPORT_RESULT, nRet);
		str.Format(IDS_INFORMATION, strMsg);
		putInOutputWindow(str);
		return OnCommandEnd(1);
	}
}
