/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// EvalSurfZebraTool.h: MGEvalSurfZebraTool NX̃C^[tFCX

#if !defined(AFX_EVALSURFZEBRATOOL_H__AC952D77_D8B7_4A60_80AB_9AE9E810159D__INCLUDED_)
#define AFX_EVALSURFZEBRATOOL_H__AC952D77_D8B7_4A60_80AB_9AE9E810159D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"
#include "ZebraDlg.h"

// class MGEvalSurfZebraTool
//
// Uses zebra stripe analysis.
class MGEvalSurfZebraTool : public MGSelectState{
public:
	explicit MGEvalSurfZebraTool(fugenDoc* pDoc);
	~MGEvalSurfZebraTool()=default;

	virtual bool can_break_into()const{return true;};

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	//virtual bool OnCommandCanceled(UINT nIDS);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);

	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
			//unselected_objects.size()>=1 only when the already selected objects are selected
			//when add mode is set(or when operation is done with a crtl key pressed).
		);

	void draw_pictures();
	void draw_pictures(COLORREF color, float dThickness, bool bVertical);
	CZebraDlg* getZebraDialog();

private:
	MGPickObjects m_objectives;///<Ώۂ̖
	COLORREF m_color; ///< Ȃ̐F
	float m_dThickness; ///< Ȃ̌
	bool m_bVertical; ///< Ȗ͗lcɂ
};


class MGEvalZebraGL: public mgSysGL{
public:
	//
	MGEvalZebraGL(
	const MGGel* gel,	///<This must be MGSurface, MGFace, or MGShell(mgAll_2Manifold).
	const mgTLInputParam& tlparam,	///<Tessellation parameter.
	const MGColor& color,	///<zebra color
	float thickness,	///<zebra thickness.
	bool is_vertical	///<direction of the zera stripes.
);

	~MGEvalZebraGL()=default;

	virtual mgSysGL* clone() const;

	//Draw this Sysgl.
	//This draw is used to draw the pictures for Undo(, Redo) operations.
	virtual void drawSysGL();


	///`֐draw()́Ais_made()ł΁A쐬A\B
	///!is_made()(`f[^쐬ς݁jł΁Ałɍ쐬ꂽmgVBOElement̕`sB
	virtual void draw(MGCL::VIEWMODE viewMode=MGCL::DONTCARE);

	///draw()mgVBOLeaf쐬ς݁inot null)ł΍쐬sȂA
	///redraw()͋Iɍč쐬s`揈ȂB
	virtual void redraw(MGCL::VIEWMODE viewMode=MGCL::DONTCARE);

	///`֐selectionDraw()́AObjectÎ߂̕\B
	///ʏdrawƂ̑F///ColorƂm_bufferIDpAsizeȊO
	///attributes̏inormal, texture, color)ȂB
	virtual void selectionDraw(MGCL::VIEWMODE viewMode=MGCL::DONTCARE);

private:
	mgTLInputParam m_tlparam;

	MGColor m_color; ///< Ȃ̐F
	float m_dThickness; ///< Ȃ̌
	bool m_bVertical; ///< Ȗ͗lcɂ
};


#endif // !defined(AFX_EVALSURFZEBRATOOL_H__AC952D77_D8B7_4A60_80AB_9AE9E810159D__INCLUDED_)
