/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// TransScale3D.h: MGEvalSSDevTool NX̃C^[tFCX

#if !defined(AFX_EVALSSDEVTOOL_H__B3A5DFFB_11C5_4DC6_8AA8_0CC79E8F74F7__INCLUDED_)
#define AFX_EVALSSDEVTOOL_H__B3A5DFFB_11C5_4DC6_8AA8_0CC79E8F74F7__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class MGObject;

#include "mg/Position.h"
#include "mg/Transf.h"
#include "mg/PickObjects.h"
#include "mgGL/Sys2GL.h"
#include "Common/CommandStateOwner.h"
#include "Common/LocateState.h"
#include "Common/SelectState.h"

// class MGEvalSSDevTool
//
// Scales objects.
// The objects are expanded or contracted in all dimensions by the scale factor.
class MGEvalSSDevTool : public MGCommandStateOwner{

public:
	explicit MGEvalSSDevTool(fugenDoc* pDoc);

	virtual bool can_break_into()const{return true;};
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();

	//display prompting message for face selection.
	void selection_message()const;

	//set the member data from the document's current object.
	void set_member_data(
		const MGPickObjects& pobjs	//pobjs must be of MGFSurface.
	);

// EVENT
	//Invoked when command is to terminate as a nomal end.
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);

private:
	// vʃIuWFNg
	MGPickObject  m_face1;
	MGPickObject  m_face2;

	friend class MGEvalSSDevToolSObj;
	friend class MGEvalSSDevToolIPoint;

	//void evaluate(fugenView*);
};

//Object selection class.
class MGEvalSSDevToolSObj : public MGSelectState{
public:
	MGEvalSSDevToolSObj(MGCommandStateOwner* owner);
	virtual bool initiate_tool();
	MGEvalSSDevTool* state_owner(){
		return static_cast<MGEvalSSDevTool*>(get_owner_command());
	}
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);
};

class MGEvalSSDevSysGL: public mgSys2GL{

public:
	MGEvalSSDevSysGL(MGPickObject surf1, MGPickObject surf2);

	const MGFSurface* surf1()const;
	const MGFSurface* surf2()const;

	//Construct new object by copying to newed area.
	//User must delete this copied object by "delete".
	virtual mgSysGL* clone()const;

	//Draw this Sysgl.
	//This draw is used to draw the pictures for Undo(, Redo) operations.
	virtual void drawSysGL();
};


#endif // !defined(AFX_MGTRANSSCALE3D_H__B3A5DFFB_11C5_4DC6_8AA8_0CC79E8F74F7__INCLUDED_)
