/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// EvalPointFromUV.h: MGEvalPointFromUVTool NX̃C^[tFCX

#if !defined(AFX_EVALPOINTFROMUV_H__ABE487AB_46EF_4227_BEF5_467C7696244E__INCLUDED_)
#define AFX_EVALPOINTFROMUV_H__ABE487AB_46EF_4227_BEF5_467C7696244E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

// class MGEvalPointFromUVTool
//
// UV W_𐶐R}h
class MGEvalPointFromUVTool : public MGSelectState{
public:
	explicit MGEvalPointFromUVTool(fugenDoc* pDoc);

	virtual bool can_break_into()const{return true;};
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnSelected(
		fugenView* pView,
		MGPickObjects& curobj,
		MGPickObjects& rejobj
		);

	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);

private:
	void calculate(const MGPickObject& pobj);
	bool input_param(const MGPickObject& pobj, MGPosition& uv);

	MGPosition m_pos; // XYZ

	bool m_bCreatePoint : 1;  // ̈ʒuɓ_𐶐邩ǂ
	bool m_bNormU : 1;        // U ͐Kꂽlw肵Ă邩ǂ
	bool m_bNormV : 1;        // V ͐Kꂽlw肵Ă邩ǂ
};

#endif // !defined(AFX_EVALPOINTFROMUV_H__ABE487AB_46EF_4227_BEF5_467C7696244E__INCLUDED_)
