/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// EvalPointFromUV.cpp: MGEvalPointFromUVTool NX̃Cve[V

#include "stdafx.h"
#include "mg/Point.h"
#include "fugen.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "EvalCmd/EvalPointFromUV.h"
#include "GLFromUVDlg.h"
#include "Misc/UserPreference.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGEvalPointFromUVTool

MGEvalPointFromUVTool::MGEvalPointFromUVTool(fugenDoc* pDoc)
 : MGSelectState(pDoc, ID_EVAL_POINTS_FROM_UV,
		 MGSelectState::SINGLE_SELECT, // single selection
		 mgAll_FSurface),
	   m_bCreatePoint(false), m_bNormU(false), m_bNormV(false)
{}

MGCommandBase* MGEvalPointFromUVTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGEvalPointFromUVTool(pDoc);
}

bool MGEvalPointFromUVTool::initiate_tool(){
	MGSelectState::initiate_tool();
	const UserPreference& pref = UserPreference::getInstance();
	m_bCreatePoint = pref.GetBoolValue(upv_Eval_PointFromUV_CreatePoint);
	m_bNormU = pref.GetBoolValue(upv_Eval_PointFromUV_NormalizeU);
	m_bNormV = pref.GetBoolValue(upv_Eval_PointFromUV_NormalizeV);

	const MGPickObjects& cobjs=current_objects();
	if(is_breaking_command()){
		MGPickObjects surfaces;
		cobjs.select_fsurfaces(surfaces);
		if(!surfaces.empty()){
			calculate(current_objects().front());
		}
		return true;
	}else if(resetCurrentObjects(mgAll_FSurface)){
		calculate(current_objects().front());
		return OnCommandEnd(1);
	}else{
		// ]ȑI
		clear_pick_object();
		CString strYesNo;
		strYesNo.LoadString(m_bCreatePoint ? IDS_YES : IDS_NO);
		SetStatusMessage(IDS_PROMPT_POINTS_FROM_UV, strYesNo);
		return false;
	}
}

bool MGEvalPointFromUVTool::terminate_tool(bool cancel)
{
	UserPreference& pref = UserPreference::getInstance();
	pref.SetBoolValue(upv_Eval_PointFromUV_CreatePoint, m_bCreatePoint);
	pref.SetBoolValue(upv_Eval_PointFromUV_NormalizeU, m_bNormU);
	pref.SetBoolValue(upv_Eval_PointFromUV_NormalizeV, m_bNormV);

	return MGSelectState::terminate_tool(cancel);
}

namespace
{
	// KĂȖʃp[^ɖ߂
	void unnormalize_param(
		const MGFSurface& surf,
		double& t,
		bool    norm_u
		){
		// MGInterval::interpolate() Lł
		t=surf.box_param2()[norm_u ? 0 : 1].interpolate(t);
	}

	// w肳ꂽ uv lɂȖʏ̓_Ԃ
	MGPosition evaluate(
		const MGFSurface& surf,
		double            u,
		double            v,
		bool              norm_u,
		bool              norm_v
		){
		// normalize ̋t
		if(norm_u)
			unnormalize_param(surf, u, true);

		// normalize ̋t
		if(norm_v)
			unnormalize_param(surf, v, false);

		// vZʂ߂
		return surf.eval(u, v);
	}
}

void MGEvalPointFromUVTool::calculate(const MGPickObject& pobj){
	MGPosition uv;
	if(!input_param(pobj,uv)){
		// cancel
		return;
	}
	
	// bZ[W
	SetStatusMessage(IDS_PROMPT_COMPUTE);
	CWaitCursor sandglass;

	// ʒuvZ
	const MGFSurface* surf = dynamic_cast<const MGFSurface*>(pobj.top_object());
	ASSERT(surf);

	MGPosition pos = evaluate(*surf, uv[0], uv[1], m_bNormU, m_bNormV);

	// KvȂhLgύX
	if(!pos.is_null()){
		if(m_bCreatePoint && !is_breaking_command())
			add_object_to_current_group(new MGPoint(pos));
		
		// ʂ\
		m_pos = pos;
		draw_temporary();		

		CString str;
		str.Format(IDS_FORMAT_COORD_3D, pos[0], pos[1], pos[2]);
		putInOutputWindow(str);
	}
}

void MGEvalPointFromUVTool::do_make_temporary_display(mgSysGL& sgl,fugenView* pView)
{
	if(m_pos.is_null()){
		return;
	}

	const MGColor& clr = MGColor::get_instance(MGColor::Magenta);
	clr.exec(sgl);
	sgl.drawPoint(m_pos[0], m_pos[1], m_pos[2]);

	CString str;
	str.Format(IDS_FORMAT_COORD_3D, m_pos[0], m_pos[1], m_pos[2]);
	sgl.drawString(str, m_pos);
}

bool MGEvalPointFromUVTool::input_param(const MGPickObject& pobj, MGPosition& uv){
	SetStatusMessage(IDS_PROMPT_PARAMETER);
	
	const MGFSurface* surf = pobj.top_object()->fsurface();
	ASSERT(surf);

	// p[^̎w肪ɖʓ|
	const MGBox& range = surf->box_param2();

	CGLFromUVDlg dlg;
	dlg.SetCaption(range[0].low_point(), range[0].high_point(), true);
	dlg.SetCaption(range[1].low_point(), range[1].high_point(), false);
	dlg.SetLimit(
		range[0].low_point(),
		range[0].high_point(),
		range[1].low_point(),
		range[1].high_point()
		);
	dlg.m_bNormU = m_bNormU;
	dlg.m_bNormV = m_bNormV;

	bool bOK = (IDOK == dlg.DoModal());
	if(bOK){
		// _CAO{bNX̎wׂċL
		m_bNormU   = (dlg.m_bNormU == TRUE);
		m_bNormV   = (dlg.m_bNormV == TRUE);
		uv= MGPosition(dlg.m_dU,dlg.m_dV);
	}
	return bOK;
}

bool MGEvalPointFromUVTool::OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags){
	switch(nChar){
	case 'c':
	case 'C':
		// _IvV؂ւ
		m_bCreatePoint = !m_bCreatePoint;

		// vvgXVi蔲j
		{
			CString strYesNo;
			strYesNo.LoadString(m_bCreatePoint ? IDS_YES : IDS_NO);
			SetStatusMessage(IDS_PROMPT_POINTS_FROM_UV, strYesNo);
		}
		break;
	default:;
	}
	return MGSelectState::OnKeyDown(pView, nChar, nRepCnt, nFlags);
}

bool MGEvalPointFromUVTool::OnSelected(
	fugenView* pView,
	MGPickObjects& curobj,
	MGPickObjects& rejobj
){
	ASSERT(curobj.size() == 1);
	ASSERT(dynamic_cast<MGFSurface*>(curobj.front().top_object()));
	// vZďI
	calculate(current_objects().front());
	return OnCommandEnd(1);
}
