/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// EvalCurvatureTool.h: MGEvalCurvatureTool NX̃C^[tFCX

#if !defined(AFX_EVALPOINTCURVATURETOOL_H__2646ECEF_3452_48C9_9170_F07A7330F5C0__INCLUDED_)
#define AFX_EVALPOINTCURVATURETOOL_H__2646ECEF_3452_48C9_9170_F07A7330F5C0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"
#include "mgGL/SysGL.h"

// class MGEvalCurvatureTool
//
// Measures a curve curvature.
class MGEvalPointCurvatureTool : public MGLocateState{
public:
	explicit MGEvalPointCurvatureTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);
	virtual bool OnLocated(const MGLocateInfo& info);
	
private:
	const MGCurve* m_curve; // ȗvZȐ
	double         m_param; // Ȑ̋ȗ߂ʒũp[^
};

class MGEvalPointCurvatureToolSysGL: public mgSysGL{

public:
	MGEvalPointCurvatureToolSysGL(const MGCurve* curve, double t)
		 :mgSysGL(ID_EVAL_RADIUS,curve),m_param(t){;};

	//Construct new object by copying to newed area.
	//User must delete this copied object by "delete".
	virtual mgSysGL* clone()const;

	//Draw this Sysgl.
	//This draw is used to draw the pictures for Undo(, Redo) operations.
	virtual void drawSysGL();

private:
	double m_param;

};

#endif // !defined(AFX_EVALPOINTCURVATURETOOL_H__2646ECEF_3452_48C9_9170_F07A7330F5C0__INCLUDED_)
