#include "stdafx.h"
#include "fugen.h"
#include "EvalParamSpace.h"


// MGEvalParamSpace

MGEvalParamSpace::MGEvalParamSpace(fugenDoc* pDoc)
	 : MGSelectState(
		pDoc
		, ID_PARAM_SPACE
		, MGSelectState::SINGLE_SELECT
		, mgAll_2Manifold)
{
}

MGCommandBase* MGEvalParamSpace::initial_clone(fugenDoc* pDoc) const
{
	return new MGEvalParamSpace(pDoc);
}

bool MGEvalParamSpace::initiate_tool()
{
	MGSelectState::initiate_tool();
	if(current_objects().size() == 1 && resetCurrentObjects(mgAll_2Manifold)){
		const MGGel* pGel = current_objects().front().top_object();
		if(!pGel->type_is(mgAll_Plane) && !pGel->type_is(mgAll_STL)){
			fugenDoc* doc = document();
			doc->InitialUpdateFrame(theApp.m_pParamTemplate, false);
			return OnCommandEnd(1);
		}
	}
	set_current_object();
	SetStatusMessage(IDS_PROMPT_EVAL_TESS_PARAM);

	return false;
}

bool MGEvalParamSpace::OnSelected(
	fugenView* window,//The fugenView pointer where point input event took place.
	MGPickObjects&	objs,	//selected objects at this selection operation.
	MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
){
	const MGGel* pGel = current_objects().front().top_object();
	if(!pGel->type_is(mgAll_Plane) && !pGel->type_is(mgAll_STL)){
		fugenDoc* doc = document();
		doc->InitialUpdateFrame(theApp.m_pParamTemplate, false);
		return OnCommandEnd(1);
	}else{
		set_current_object();
		return false;
	}
}