/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// EvalCurvatureTool.h: MGEvalCurvatureTool NX̃C^[tFCX

#if !defined(AFX_EvalKnots_H__2646ECEF_3452_48C9_9170_F07A7330F5C0__INCLUDED_)
#define AFX_EvalKnots_H__2646ECEF_3452_48C9_9170_F07A7330F5C0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"
#include "mgGL/SysGL.h"

// class MGEvalKnotsTool
// Display knot points of curves.
class MGEvalKnotsTool : public MGSelectState{
public:
	explicit MGEvalKnotsTool(fugenDoc* pDoc);

	virtual bool can_break_into()const{return true;};
	void draw_knots(const MGPickObjects& objs);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);

	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	selected_objects,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);
};

class MGEvalKnotsToolSysGL: public mgSysGL{

public:
	MGEvalKnotsToolSysGL(const MGGel* curve)
		 :mgSysGL(ID_SYSD_KNOTS,curve){;};

	//Construct new object by copying to newed area.
	//User must delete this copied object by "delete".
	virtual mgSysGL* clone()const;

	//Draw this Sysgl.
	//This draw is used to draw the pictures for Undo(, Redo) operations.
	virtual void drawSysGL();

};

#endif // !defined(AFX_EvalKnots_H__2646ECEF_3452_48C9_9170_F07A7330F5C0__INCLUDED_)
