/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
#pragma once

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"

class CEdgeShowDlg;

/// @class MGEvalEdgeShowTool EvalEdgeShowTool.h
///
/// ́GbWc[GbW\
class MGEvalEdgeShowTool : public MGSelectState{
public:
	explicit MGEvalEdgeShowTool(fugenDoc* pDoc);
	~MGEvalEdgeShowTool();
	bool can_break_into() const{return true;};
	MGCommandBase* initial_clone(fugenDoc* pDoc)const;

	bool initiate_tool();
	bool OnSelected(fugenView* pView,MGPickObjects& added,MGPickObjects& removed);
	void UpdateView(const MGPickObjects& target);
	bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//=2: display "xxxx" failed.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
				//true when draw_temporary() pictures are to erase.
				//false if draw_temporary() pictures are to stay displayed.
	);//This is overrided to make erase_temporary_display false.
};
