/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
#include "stdafx.h"
#include "Misc/UserPreference.h"
#include "EvalCmd/EvalEdgeShowTool.h"
#include "EvalCmd/EvalEdgeGraphic.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

MGEvalEdgeShowTool::MGEvalEdgeShowTool(fugenDoc* pDoc)
:MGSelectState(pDoc,ID_EDGE_SHOW,MULTIPLE_SELECT,mgAll_2Manifold){}

MGEvalEdgeShowTool::~MGEvalEdgeShowTool(){}

MGCommandBase* MGEvalEdgeShowTool::initial_clone(fugenDoc* pDoc) const{
	return new MGEvalEdgeShowTool(pDoc);
}

bool MGEvalEdgeShowTool::initiate_tool(){
	MGSelectState::initiate_tool();

	// ʂɊGcĂꍇ邽߁ANAmɂB
	//document()->DeleteDisplayList(ID_EDGE_SHOW);

	// 荞݃R}h̏ꍇ́Ȃ݂IZbgύXȂƁB
	// ɃtB^[Ă̓_B
	if(is_breaking_command()){
		MGPickObjects target = current_objects();
		target.reset_objects(mgAll_2Manifold);
		UpdateView(target);
		return true;// 荞ݏIB
	}

	// ʏNP[X
	if(resetCurrentObjects(mgAll_2Manifold)){
		UpdateView(current_objects());
		return MGSelectState::OnCommandEnd(1,false);
	}
	
	SetStatusMessage(IDS_PROMPT_EDGE_SHOW_SEL);
	return false;
}

void MGEvalEdgeShowTool::UpdateView(const MGPickObjects& target){
	COLORREF color = 0;
	UserPreference& pref = UserPreference::getInstance();
	color = pref.GetIntValue(upv_Eval_EdgeShow_Color);

	//erase_temporary(0, false); // repaint Ȃ
	MGPickObjects::const_iterator first = target.begin(), last = target.end();
	for(; first != last; ++first){
		draw_temporary(
			new MGEvalEdgeGraphic(ID_EDGE_SHOW, (*first)->top_object(), color),
			false, // erase Ȃ
			false); // repaint Ȃ
	}

	//  repaint B
	InvalidateAllStdViews();
}

bool MGEvalEdgeShowTool::OnSelected(
	fugenView* pView,
	MGPickObjects& added,
	MGPickObjects& removed
){
	UpdateView(current_objects());
	return MGSelectState::OnCommandEnd(1,false);
}

bool MGEvalEdgeShowTool::OnCommandEnd(
	UINT nIDS,	//=0: erase the current message, and display no messages.
			//=1: display "xxxx" normally end.
			//=2: display "xxxx" failed.
			//otherwise: nIDS is a string id, and load the message from string table to display.
	bool erase_temporary_display
			//true when draw_temporary() pictures are to erase.
			//false if draw_temporary() pictures are to stay displayed.
){
	return MGSelectState::OnCommandEnd(1,false);
}
