/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// EvalDistance2PTool.cpp: MGEvalDistance2PTool NX̃Cve[V

#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "EvalCmd/EvalDistanceTool.h"
#include "EvalCmd/EvalDistance2PTool.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGEvalDistance2PTool

MGEvalDistance2PTool::MGEvalDistance2PTool(fugenDoc* pDoc)
: MGLocateState(pDoc, ID_EVAL_DISTANCE_2P, LINE_RUBBER, POINT_IPDRAW)
{
}

MGCommandBase* MGEvalDistance2PTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGEvalDistance2PTool(pDoc);
}

bool MGEvalDistance2PTool::OnLocated(
	const MGLocateInfo& linfo
){
	const LInfoVec& linfos=locates();
	size_t np = linfos.size();
	
	if(np<=1){
		return false;
	}else{
		const MGPosition& P0=linfos[0]->point_world();
		const MGPosition& P1=linfos[1]->point_world();
		m_pos1 = P0;
		m_pos2 = P1;
		draw_temporary();
		return OnCommandEnd(1,false);
	}
}

void MGEvalDistance2PTool::prompt_message() const{
	SetStatusMessage(IDS_PROMPT_POSITION_NTH, locates().size()+1);
}

void MGEvalDistance2PTool::do_make_temporary_display(mgSysGL& sgl,fugenView* pView){
	const LInfoVec& linfos=locates();
	if(linfos.size()<=1)
		return;

	const MGPosition& posm = (m_pos1 + m_pos2) * .5;
	const MGColor& clr1 = MGColor::get_instance(MGColor::Magenta);
	const MGColor& clr2 = MGColor::get_instance(MGColor::Cyan);
	const MGColor& clrm = MGColor::get_instance(MGColor::White);

	clr1.exec(sgl);
	sgl.drawPoint(m_pos1[0], m_pos1[1], m_pos1[2]);

	clr2.exec(sgl);
	sgl.drawPoint(m_pos2[0], m_pos2[1], m_pos2[2]);

	sgl.Begin(GL_LINE_STRIP);
		sgl.Color(clr1);//clr1.exec(sgl);
		sgl.Vertex3dv(m_pos1.data());
		sgl.Color(clrm);//clrm.exec(sgl);
		sgl.Vertex3dv(posm.data());
		sgl.Color(clr2);//clr2.exec(sgl);
		sgl.Vertex3dv(m_pos2.data());
	sgl.End();

	double dist = m_pos1.distance(m_pos2);
	CString str;
	str.Format(IDS_FORMAT_DISTANCE, dist);
	sgl.drawString(str, posm);
}
