/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/*
 * EvalCurveLengthTool.cpp: ́ j[̃R}hNX
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "EvalCmd/EvalCurveLengthTool.h"

MGEvalCurveLength::MGEvalCurveLength(fugenDoc* pDoc)
:MGSelectState(pDoc,ID_EVAL_CURVE_LENGTH,
		 MGSelectState::MULTIPLE_SELECT,
		 mgAll_Curve){
}

MGCommandBase* MGEvalCurveLength::initial_clone(fugenDoc* pDoc) const
{
	return new MGEvalCurveLength(pDoc);
}


bool MGEvalCurveLength::initiate_tool(){
	MGSelectState::initiate_tool();

	// ݂̑IȐ݂̂c悤ɃtB^[B
	const MGPickObjects& cursel = current_objects();
	MGPickObjects newsel;
	cursel.select_curves(newsel);

	// ݂̑IȐ̌𒲂ׂB
	// ɑIĂ΁AvZR}hIB
	if(!newsel.empty()){
		evaluate(newsel);
		return true;
	}

	if(is_breaking_command()){
		return true;
	}

	// INAB
	set_current_object(newsel);

	// ŏ̃bZ[W
	prompt_message();
	return false;
}

bool MGEvalCurveLength::terminate_tool(bool bCancel)
{
	// TODO: ꏈǉɂȂ炱ɁB
	
	return MGSelectState::terminate_tool(bCancel);
}

bool MGEvalCurveLength::OnSelected(
	fugenView*,
	MGPickObjects&,
	MGPickObjects&)
{
	const MGPickObjects& cursel = current_objects();
	if(!cursel.empty()){
		evaluate(cursel);
		return OnCommandEnd(1);
	}
	prompt_message();
	return false;
}

void MGEvalCurveLength::evaluate(const MGPickObjects& curves) const
{
	const size_t nCurve = curves.size();
	double dLenTotal = 0.0;

	for(size_t i = 0; i < nCurve; i++){
		auto curve = dynamic_cast<const MGCurve*>(curves[i].top_object());
		if(curve){
			dLenTotal += curve->length();
		}
	}

	// o̓EBhEɒo
	CString str;
	if(nCurve == 1){
		str.Format(IDS_EVAL_LENGTH_RESULT, dLenTotal);
	}
	else{
		str.Format(IDS_EVAL_LENGTH_TOTAL_RESULT, nCurve, dLenTotal);
	}
	putInOutputWindow(str);
}

void MGEvalCurveLength::prompt_message() const
{
	SetStatusMessage(IDS_PROMPT_CURVE);
}
