/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// EvalCurveDevi.h: MGEvalCurveDeviTool NX̃C^[tFCX

#if !defined(AFX_EVALCURVEDEVI_H__104047E8_57C2_45D6_84D6_80D71C000148__INCLUDED_)
#define AFX_EVALCURVEDEVI_H__104047E8_57C2_45D6_84D6_80D71C000148__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mgGL/SysGL.h"
#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"
class MGCurve;

// class MGEvalCurveDeviTool
//
// 2Ȑ̗vR}h
class MGEvalCurveDeviTool : public MGSelectState{
public:
	explicit MGEvalCurveDeviTool(fugenDoc* pDoc);

	virtual bool can_break_into()const{return true;};
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);

	//Invoked when command is to terminate as a nomal end.
	//display normal end message.
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//=2: display "xxxx" failed.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
				//true when draw_temporary() pictures are to erase.
				//false if draw_temporary() pictures are to stay displayed.
	);

	//Display the deviation of the two curves.
	void show(MGPickObject& curve1, MGPickObject& curve2);

private:
	MGPickObject m_curve1; // ΏۋȐ1
	MGPickObject m_curve2; // ΏۋȐ2
};

class MGEvalCurveDeviSysGL: public mgSysGL
{
public:
	MGEvalCurveDeviSysGL(MGPickObject curve1, MGPickObject curve2);

	//Construct new object by copying to newed area.
	//User must delete this copied object by "delete".
	virtual mgSysGL* clone() const;

	//Draw this Sysgl.
	//This draw is used to draw the pictures for Undo(, Redo) operations.
	virtual void drawSysGL();

	//Test if this mgSysGL includes gel(return true) or not.
	bool includes(const MGGel* gel)const;

	//replace gel_old to gel_new.
	//If gel_old is not included in this, do nothing.
	void replace(
		const MGGel* gel_old, //gel_old must be a MGCurve.
		const MGGel* gel_new //gel_new must be a MGCurve.
		);

	// Output virtual function.
	//Output to stream file:of[^Wo͂ɏo͂B
	virtual std::ostream& out(std::ostream& ostrm) const;

private:
	MGCurve* m_gel2;//2nd curve. 1st curve is stored in mgSysGL's m_gel.

};

#endif // !defined(AFX_EVALCURVEDEVI_H__104047E8_57C2_45D6_84D6_80D71C000148__INCLUDED_)
