/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file EvalCurvatureTool.h
 * @brief MGEvalCurvatureTool NX̃C^[tFCX
 */
#if !defined(AFX_EVALCURVECURVATURETOOL_H__2646ECEF_3452_48C9_9170_F07A7330F5C0__INCLUDED_)
#define AFX_EVALCURVECURVATURETOOL_H__2646ECEF_3452_48C9_9170_F07A7330F5C0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"
#include "mgGL/SysGL.h"

class CCurvaDlg;

// class MGEvalCurveCurvatureTool
//
// Measures a curve curvature.
class MGEvalCurveCurvatureTool : public MGSelectState{
	friend class CCurvaDlg;

public:
	explicit MGEvalCurveCurvatureTool(fugenDoc* pDoc);
	bool can_break_into()const{return true;};
	MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	bool initiate_tool();
	bool terminate_tool(bool cancel=false);
	bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
		//=1: display "xxxx" normally end.
		//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);
	bool OnCommandCanceled(
		UINT nIDS	//=0: erase the current message, and display no messages.
		//=1: display "xxxx" cancelled.
		//otherwise: nIDS is a string id, and load the message from string table to display.
		);

	bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	selected_objects,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
	);

	void draw_graph();
	
private:
	void extractCurvesFromtCurrent(MGPickObjects& curves);
};

class MGEvalCurveCurvatureToolSysGL: public mgSysGL{
	double m_scale; ///< ۂ̒̒lŏ悶Ċgk
	int m_density; ///< qQ̖x
	bool m_use_radius; ///< ȗaqQ̒ƂȂ true
	bool m_bNegate; ///< 𔽓]Ȃ true

public:
	MGEvalCurveCurvatureToolSysGL(
		const MGGel* curve,
		double scale,
		int density,
		bool use_radius,
		bool bNegate);

	//Construct new object by copying to newed area.
	//User must delete this copied object by "delete".
	virtual mgSysGL* clone()const;

	//Draw this Sysgl.
	//This draw is used to draw the pictures for Undo(, Redo) operations.
	virtual void drawSysGL();
};

#endif // !defined(AFX_EVALCURVECURVATURETOOL_H__2646ECEF_3452_48C9_9170_F07A7330F5C0__INCLUDED_)
