/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// EvalCurveCont.h: MGEvalCurveContTool NX̃C^[tFCX

#if !defined(AFX_EVALCURVECONT_H__7001C0F3_6C5F_470B_BFEB_74FF1B707378__INCLUDED_)
#define AFX_EVALCURVECONT_H__7001C0F3_6C5F_470B_BFEB_74FF1B707378__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

// class MGEvalCurveContTool
//
// Measures geometric continuity.
// Tangency and curvature continuity information.
class MGEvalCurveContTool : public MGSelectState{
public:
	explicit MGEvalCurveContTool(fugenDoc* pDoc);
	void evaluate(const MGPickObjects& curves);

	virtual bool can_break_into()const{return true;};
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	selected_objects,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);
private:
	void prompt_message() const;
};

#endif // !defined(AFX_EVALCURVECONT_H__7001C0F3_6C5F_470B_BFEB_74FF1B707378__INCLUDED_)
