/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// EvalCurvatureTool.h: MGEvalCurvatureTool NX̃C^[tFCX

#if !defined(AFX_EvalCPoly_H__2646ECEF_3452_48C9_9170_F07A7330F5C0__INCLUDED_)
#define AFX_EvalCPoly_H__2646ECEF_3452_48C9_9170_F07A7330F5C0__INCLUDED_

#pragma once
#include "Common/SelectState.h"
#include "mgGL/SysGL.h"

// class MGEvalCPolyTool
// Display control polygons of spline curves or surfaces.
class MGEvalCPolyTool : public MGSelectState{
public:
	explicit MGEvalCPolyTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	selected_objects,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
			//unselected_objects.size()>=1 only when the already selected objects are selected
			//when add mode is set(or when operation is done with a crtl key pressed).
	);
	virtual bool can_break_into()const{return true;};
};

class MGEvalCPolyToolSysGL: public mgSysGL{
public:
	MGEvalCPolyToolSysGL(const MGGel* curve)
		 :mgSysGL(ID_SYSD_CPOLY_ON,curve){;};

	//Construct new object by copying to newed area.
	//User must delete this copied object by "delete".
	virtual mgSysGL* clone()const;

	//Draw this Sysgl.
	//This draw is used to draw the pictures for Undo(, Redo) operations.
	virtual void drawSysGL();
};

#endif // !defined(AFX_EvalCPoly_H__2646ECEF_3452_48C9_9170_F07A7330F5C0__INCLUDED_)
