/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// EvalCPoly.cpp: MGEvalCPolyTool NX̃Cve[V

#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "EvalCmd/EvalCPolyTool.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGEvalCPolyTool

MGEvalCPolyTool::MGEvalCPolyTool(fugenDoc* pDoc)
:MGSelectState(pDoc,ID_SYSD_CPOLY_ON,MULTIPLE_SELECT){}

MGCommandBase* MGEvalCPolyTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGEvalCPolyTool(pDoc);
}

bool MGEvalCPolyTool::initiate_tool(){
	MGSelectState::initiate_tool();
	if(resetCurrentObjects(mgAll_Object)){
		const MGPickObjects& objs=current_objects();
		size_t n=objs.size();
		for(size_t i=0; i<n; i++){
			draw_temporary(new MGEvalCPolyToolSysGL(objs[i].top_object()),false,false);
		}
	}

	if(is_breaking_command())
		return true;//If breaking into the other command, terminate this command.

	// Selection message.
	SetStatusMessage(IDS_PROMPT_TARGET);
	return false;
}

bool MGEvalCPolyTool::OnCommandEnd(
	UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
	bool erase_temporary_display
){
	return MGSelectState::OnCommandEnd(1,false);//Control polygons stays displayed.
}

bool MGEvalCPolyTool::OnSelected(
	fugenView* window,//The fugenView pointer where point input event took place.
	MGPickObjects&	selected_objects,	//selected objects at this selection operation.
	MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
){
	if(unselected_objects.size()){
		size_t n=unselected_objects.size();
		for(size_t i=0; i<n; i++){
			erase_temporary(unselected_objects[i].top_object(),false);
		}
	}else{
		size_t n=selected_objects.size();
		for(size_t i=0; i<n; i++){
			draw_temporary(new MGEvalCPolyToolSysGL(selected_objects[i].top_object()),false,false);
		}
	}
	InvalidateAllStdViews();
	return false;
}

//Construct new object by copying to newed area.
//User must delete this copied object by "delete".
mgSysGL* MGEvalCPolyToolSysGL::clone()const{
	return new MGEvalCPolyToolSysGL(*this);
}

//Draw this Sysgl.
//This draw is used to draw the pictures for Undo(, Redo) operations.
void MGEvalCPolyToolSysGL::drawSysGL(){
	MGColor::get_instance(MGColor::White).exec(*this);
	setLineStipple(2,0x5555);
	auto obj = dynamic_cast<const MGObject*>(object_id());
	if(obj)
		obj->display_control_polygon(*this);
}
