/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// EvalAngle.h: MGEvalAngleTool NX̃C^[tFCX

#if !defined(AFX_EVALANGLE_H__A361D25F_4682_4D85_9695_FD5445062939__INCLUDED_)
#define AFX_EVALANGLE_H__A361D25F_4682_4D85_9695_FD5445062939__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"
#include "mg/Ellipse.h"

// class MGEvalAngleTool
//
// Measures the angle between two lines.
class MGEvalAngleTool : public MGLocateState{

	MGEllipse m_arc; ///< `p
	MGPosition m_pos; ///< px`悷ʒu
	double m_dAngle; ///< ]px

public:
	explicit MGEvalAngleTool(fugenDoc* pDoc);
	virtual bool can_break_into() const{return true;};
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool OnLocated(const MGLocateInfo& info);

	/////////////////functions for draw_temporary()////////////
	void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	void prompt_message() const;
};

#endif // !defined(AFX_EVALANGLE_H__A361D25F_4682_4D85_9695_FD5445062939__INCLUDED_)
