/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// EvalAngle.cpp: MGEvalAngleTool NX̃Cve[V

#include "stdafx.h"
#include "mg/Straight.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "EvalCmd/EvalAngle.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGEvalAngleTool

MGEvalAngleTool::MGEvalAngleTool(fugenDoc* pDoc)
: MGLocateState(pDoc,ID_EVAL_ANGLE,NO_RUBBER,POINT_IPDRAW){
}

MGCommandBase* MGEvalAngleTool::initial_clone(fugenDoc* pDoc)const{
	return new MGEvalAngleTool(pDoc);
}

void MGEvalAngleTool::do_make_temporary_display(mgSysGL& sgl,fugenView* pView){
	const LInfoVec& linfos=locates();
	size_t np = linfos.size();
	const bool bFinal = (np==4);
	
	if(np>=1){
		const MGPosition& P0=linfos[0]->point_world();
		MGColor::get_instance(bFinal ? MGColor::White : MGColor::SpringGreen).exec(sgl);
		sgl.Begin(GL_LINES);
		sgl.Vertex3dv(P0.data());
		if(np>=2){
			const MGPosition& P1=linfos[1]->point_world();
			sgl.Vertex3dv(P1.data());
		}else{
			sgl.Vertex3dv(cursor().data());
		}
		if(np>= 3){
			const MGPosition& P2=linfos[2]->point_world();
			sgl.Vertex3dv(P2.data());
			sgl.Vertex3dv(bFinal ? linfos[3]->point_world().data() : cursor().data());
		}
		sgl.End();

		if(!m_pos.is_null() && bFinal){
			m_arc.drawWire(sgl);

			CString str;
			str.Format(_T("%8.3f deg"), m_dAngle);
			sgl.drawString(str, m_pos);
		}		
	}
}

bool MGEvalAngleTool::OnLocated(const MGLocateInfo& info){
	const LInfoVec& linfos=locates();
	size_t np = linfos.size();
	if(np<4){
		return false;
	}
	
	// 4_łvZɓăR}hIƂȂ	
	const MGPosition& P0=linfos[0]->point_world();
	const MGPosition& P1=linfos[1]->point_world();
	const MGPosition& P2=linfos[2]->point_world();
	const MGPosition& P3=linfos[3]->point_world();
	MGVector v1 = (P1-P0);
	MGVector v2 = (P3-P2);
	double ang = MGCL::radian_to_degree(v1.angle(v2));

	CString str;
	str.Format(IDS_EVAL_ANGLE_RESULT, ang);
	COUT << (TCAST)str << std::endl;

	MGStraight line1(MGSTRAIGHT_UNLIMIT, v1, P0);
	MGStraight line2(MGSTRAIGHT_UNLIMIT, v2, P2);
	MGCCisects is = line1.isect(line2);
	if(!is.empty()){
		MGVector v1U = v1.normalize(), v2U = v2.normalize();
		auto& cci = isectCast<MGCCisect>(is.begin());
		MGPosition& cross = cci.point();
		double r = v1.len(), v2l = v2.len();
		if(r>v2l)
			r = v2l;

		r *= .3;
		m_pos = cross + v1U.interpolate_by_rotate(0.5, v2U)*r;
		m_arc = MGEllipse(cross, cross + v1U*r, cross + v2U*r, v1U * v2U);
	}
	m_dAngle = ang;
	draw_temporary();
	return OnCommandEnd(1, false);
	//temporal display made by do_make_temporary_display() stays displayed.
}

void MGEvalAngleTool::prompt_message() const{
	switch(locates().size()){
	case 0:
		SetStatusMessage(IDS_PROMPT_LINE_START_NTH, 1);
		break;
	case 1:
		SetStatusMessage(IDS_PROMPT_LINE_END_NTH, 1);
		break;
	case 2:
		SetStatusMessage(IDS_PROMPT_LINE_START_NTH, 2);
		break;
	case 3:
		SetStatusMessage(IDS_PROMPT_LINE_END_NTH, 2);
		break;
	}
}
