/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file editfunc.h
 * @brief EditCmd nŋʂŗp@\錾ĂB
 *
 * ړÍAc[NX cpp 珃ɌvZ𕪗邱ƂB
 * XʃW[₷Ȃ͂B
 */
#pragma once

class MGGelPositions;
class MGGroup;
class MGObject;
class MGPosition;
class MGPickObject;
class MGPickObjects;
class MGVector;

class MGCommandBase;
class fugenView;

/// zIvVL̐ؒfIuWFNge߂B
/// @param[in] c_or_p ؒfIuWFNg
/// @param[in] pView gCxgr[
/// @param[in] bApparentIntersection zLɂ邩
/// @return e܂΁A̕B
/// @throws ʂȗO͓ȂB
///
/// e͕R}hƓl̃[Ō肵AUI vZ
/// (MGCL) Ɏw邱ƁB
///
/// -# z ON ̏ꍇAer[ƂB
/// -# gCxgsr[ŔꍇAؒfIuWFNg
///    Ȑ܂͓_Ȃ΂r[ɓeB
/// -# gCxg}r[ŔAؒfIuWFNgʋȐłꍇA
///    ؒfȐȐʂɑ΂Đȕ֓eB
/// -# ȊȌꍇAIuWFNg̓e MGCL vZuʒvƂB
MGVector GetObjProjDir(
	const MGObject& c_or_p,
	const fugenView* pView,
	bool bApparentIntersection);

/// Ȑ^Cv
/// @see ExtendNaive
enum ExtendType
{
	START, ///< n_
	END, ///< I_
	BOTH, ///< n_ƏI_
};

/// Ȑ̗[ƂɂĐVȐԂB
/// @param[in] curve Ȑ
/// @param[in] dExtend ̒
/// @param[in] type ^Cv
/// @return ȐԂB
/// @throws ʂȗO͓ȂB
///
/// @pre dExtend > MGTolerance::wc_zero
///
/// @a curve łȂ`̏ꍇ́A߂l͌Ɠ`ƂȂB
/// ɂ߂l new IuWFNgłAĂяo
/// delete KvB
///
/// @a curve ̏ꍇA̒𖳌ƂB
MGCurve* ExtendCurveNaive(
	const MGCurve& curve,
	double dLength,
	ExtendType type);

/// sbNȐ𕡐̃sbNIuWFNgŃgB
/// @param[in] trimmee g^[QbgȐ
/// @param[in] Ctrimmers ؒfȐQ
/// @param[in] Strimmers ؒfT[tFXQ
/// @param[in] pView gCxgr[
/// @param[in] bExtendCutters ؒfȐQ邩
/// @param[in] bApparentIntersection zLɂ邩
/// @param[in,out] cmd R}hiۂ̓hLgj
/// @param[in] bExtract gł͂Ȃos
/// @return gm肵ăhLgɕύX true ԂB
/// @throws ʂȗO͓ȂB
///
/// @note  MGTrimTool::trim_curve
bool ExecTrimCurve(
	MGPickObject& trimmee,
	const MGPickObjects& Ctrimmers,
	const MGPickObjects& Strimmers,
	const fugenView* pView,
	bool bExtendCutters,
	bool bApparentIntersection,
	MGCommandBase& cmd,
	bool bExtract = false);

/// sbNT[tFX𕡐̃sbNIuWFNgŃgB
/// @param[in] surface surface to trim (trimmee).
/// @param[in] Ctrimmers ؒfȐQ
/// @param[in] Strimmers ؒfT[tFXQ
/// @param[in] dir projection direction to project @a Ctrimmers onto the surface.
/// @param[in] bExtendCutters ؒfȐQ邩
/// @param[in,out] cmd R}hiۂ̓hLgj
/// @param[in] bExtract gł͂Ȃos
/// @return gm肵ăhLgɕύX true ԂB
/// @throws ʂȗO͓ȂB
///
/// @note  MGTrimTool::trim_fsurface
bool ExecTrimFSurf(
	MGPickObject& surface,
	const MGPickObjects& Ctrimmers,
	const MGPickObjects& Strimmers,
	const MGVector& dir,
	bool bExtendCutters,
	MGCommandBase& cmd,
	bool bExtract = false);

/// R}hsi_Eɂj
/// @param[in,out] target ̑ΏۗvfiȐT[tFXj
/// @param[in,out] cutter ؒfʒu߂邽߂̗vfQ
/// @param[in,out] cmd R}hiۂ̓hLgj
/// @return Ȑ̃p[č
/// @throws ʂȗO͓ȂB
size_t ExecSplitByIntersection(
	MGPickObjects& target,
	const MGPickObjects& cutter,
	MGCommandBase& cmd);

/// ⏕֐
/// @param[in,out] target ̑ΏۋȐ
/// @param[in,out] params ʒűȐp[^B
///    ĂяoAe̓\[gĂB
/// @param[in,out] parent
/// @return 
MGGelPositions ExecSplitCurveByParam(
	MGPickObject& target,
	std::vector<double>& params,
	MGGroup* parent);

/// ⏕֐
/// @param[in,out] target ̑ΏۃT[tFX
/// @param[in,out] curves ʒu߂ȐQ
/// @param[in,out] parent
/// @return 
MGGelPositions ExecSplitSurfByCurve(
	MGPickObject& target,
	const std::vector<const MGCurve*>& curves,
	MGGroup* parent);

/// R}hsiȐP[g_Łj
/// @param[in,out] target ̑ΏۋȐ
/// @param[in,out] params ʒűȐp[^B
///    ĂяoAe̓\[gĂB
/// @param[in,out] cmd R}hiۂ̓hLgj
/// @return Ȑ̃p[č
/// @throws ʂȗO͓ȂB
///
/// @note  MGSplitTool::SplitCurveByPoints
///
/// @bug Ȑ̕ł́u[_v܂ރZOgołĂȂB
size_t ExecSplitCurveByPoints(
	MGPickObject& target,
	std::vector<double>& params,
	MGCommandBase& cmd);

/// R}hsiT[tFXAC\J[uŁj
/// @param[in,out] target ̑ΏۃT[tFX
/// @param[in,out] uparams ʒu U AC\J[u
/// @param[in,out] vparams ʒu V AC\J[u
/// @param[in,out] cmd R}hiۂ̓hLgj
/// @return T[tFX̃p[č
/// @throws ʂȗO͓ȂB
size_t ExecSplitSurfByIsocurves(
	MGPickObject& target,
	std::vector<bool>& paramKinds,
	std::vector<double>& params,
	MGCommandBase& cmd);
