/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file SplitTool.h
 * @brief NX MGSplitTool ̐錾
 */
#if !defined(AFX_SPLITTOOL_H__3E14647F_E042_4C50_B1A8_BE5A16BE2FFE__INCLUDED_)
#define AFX_SPLITTOOL_H__3E14647F_E042_4C50_B1A8_BE5A16BE2FFE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"
#include "SurfCmd/SplitLocateIsoCurves.h"

/// ^Cv
enum SplitBy{
	ByIntersection, ///< ʏ̕BJb^[IuWFNgƂ̌_EgpB
	ByPoints, ///< ^[Qbg̋Ȑ_gpB
	ByIsocurves, ///< ^[Qbg̃AC\J[ugpB
};

/// @class MGSplitTool SplitTool.h "EditCmd/SplitTool.h"
///
/// Splits an object.
/// You can split curves and surfaces with curves, surfaces and shell. 
/// Shells can only be split with surfaces and shells.
///
/// When you split a surface with a curve in a plan parallel view 
/// like the fugenView2Dxy, fugenView2Dyz, and fugenView2Dxz view, 
/// the cutting curve is projected on the surface in the view direction.
///
/// When you split a surface with a planar curve in an angled parallel
/// or a perspective view like the default fugenView view, the cutting
/// curve is projected on the surface in a direction perpendicular to 
/// the curve plane.
///
/// When you split a surface with a 3-D curve in an angled parallel
/// or a perspective view, the cutting curve is pulled on the surface
/// by closest points.
///
/// @note dl doc/edit-split.doc ɂB
class MGSplitTool : public MGCommandStateOwner{
	friend class MGSplitLocatePoints;
	friend class MGSplitLocateIsocurves;
	friend class MGSplitSelCutter;
	friend class MGSplitSelTarget;
	friend class MGSplitSelTargetSurf;

	SplitBy m_splitMode;
	MGPickObjects m_target; ///< R}h̃^[Qbg
	MGPickObjects m_cutter; ///< ByInterface ɂJb^[vf

	///m_param[i], m_preview_points[i] is a pair.
	std::vector<double> m_param; ///< Ȑ_ŕۂɗp.
		///<Parameter valu of the curve m_target.
	std::vector<MGPosition> m_preview_points; ///< ByPoints ɂm蕪

public:
	explicit MGSplitTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc) const;
	virtual bool initiate_tool();

	virtual bool OnCommandEnd(UINT nIDS,bool erase_temporary_display=true);
	virtual bool OnCommandCanceled(UINT nIDS);
	SplitBy GetSplitType() const;
	void SetSplitType(SplitBy mode);

	/// R}h̃^[Qbg擾B
	const MGPickObjects& GetSplitTarget() const;

	/// R}h̃^[QbgZbgB
	void SetSplitTarget(const MGPickObjects& target);

	const MGPickObjects& GetCutter() const;

	/// Jb^[Zbg
	void SetCutter(const MGPickObjects& added, const MGPickObjects& removed);

	/// ByPoints p
	//@{
	const MGCurve* GetSplitTargetCurve() const;
	void AddSplitParam(double dParam);
	//@}

	/// ByIsocurves p
	//@{
	const MGFSurface* GetSplitTargetSurf() const;
	void AddSplitParam(const MGPosition& uv, bool bU);
	//@}
	
	/// ByPointsp
	void RemoveSplitParam();


private:
	/// ܂ł̕_`B
	void DrawPoints(mgSysGL& sgl,fugenView* pView) const;
};

/*
  split

1. IuWFNgI[]
	Iׂ: curve, surface, face, shell

2. ؒfIuWFNgI[]
	1. shellЂƂłI΂ĂƂ
	surface, face, shellI邱ƂłȂ(R͕s)
	
	curve \ point
		_ŕ邾BeƂ]vȂƂ͂ȂB
		_ꍇAɕꂽ̂𕪊B
		
		
		
	curve \ curve
	surface \ curve
	face \ curve

            r[̎   2D                     perspective
Ȑ̎
ʋȐ                   r[ɓe       average plane̖@ɓe
3DȐ                     r[ɓe       ʒe


	curve \ surface
	surface \ surface
	face \ surface
	shell \ surface
		PȂvZƂȂB̌ŕB
	
		ʂƂċL悤ȏꍇʓ|
	
	face \ face
	shell \ face
	
	shell \ shell
	
curveɂsplit:

  */

/// @class MGSplitSelTarget
///
/// IuWFNgI state
/// @note dl [S1] ɑԂ\B
class MGSplitSelTarget : public MGSelectState{
public:
	MGSplitSelTarget(MGSplitTool* owner);

	MGSplitTool* state_owner(){
		return static_cast<MGSplitTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* window, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnSelected(
		fugenView* pView,
		MGPickObjects& added,
		MGPickObjects& removed);

private:
	void prompt_message()const;
	bool CanChangeSelCurveState() const;///<test if no selection or current objects include curve.
	bool CanChangeSelSurfState() const;///<test if no selection or current objects include fsurface.
	bool CanChangeSelSpecialTargetState(const MGAbstractGels& type) const;
};

/// @class MGSplitSelTargetCurve
///
/// ؒfIuWFNgƂăJ[u{IXe[gB
/// @note dl [S2] ɑB
class MGSplitSelTargetCurve : public MGSelectState{
public:
	MGSplitSelTargetCurve(MGSplitTool* owner);

	MGSplitTool* state_owner(){
		return static_cast<MGSplitTool*>(get_owner_command());
	}

	virtual bool initiate_tool();

	virtual bool OnSelected(
		fugenView* pView,
		MGPickObjects& added,
		MGPickObjects& removed);

private:
	void prompt_message()const;
};

/// @class MGSplitSelCutter
///
/// ؒfIuWFNgIXe[gB
/// @note dl [S3] ɑB
class MGSplitSelCutter : public MGSelectState{
public:
	MGSplitSelCutter(MGSplitTool* owner);

	MGSplitTool* state_owner(){
		return static_cast<MGSplitTool*>(get_owner_command());
	}
	const MGSplitTool* state_owner()const{
		return static_cast<const MGSplitTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* window, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnSelected(
		fugenView* pView,
		MGPickObjects& added,
		MGPickObjects& removed);

private:
	void prompt_message()const;

	bool CanChangeLocatePointsState()const; // [S5]
	bool CanChangeLocateIsocurvesState()const; // [S6]
	bool CanChangeLocateSpecialState(const MGAbstractGels& type)const;
};

/// @class MGSplitSelTargetSurf
///
/// ؒfIuWFNgƂăJ[u{IXe[gB
/// @note dl [S4] ɑB
class MGSplitSelTargetSurf : public MGSelectState{
public:
	MGSplitSelTargetSurf(MGSplitTool* owner);

	MGSplitTool* state_owner(){
		return static_cast<MGSplitTool*>(get_owner_command());
	}

	virtual bool initiate_tool();

	virtual bool OnSelected(
		fugenView* pView,
		MGPickObjects& added,
		MGPickObjects& removed);

private:
	void prompt_message()const;
};

/// @class MGSplitLocatePoints
///
/// ^[QbgȐ{̎̓ʕXe[gB
/// @note dl [S5] ɑB
class MGSplitLocatePoints : public MGLocateOnObjects{
public:
	MGSplitLocatePoints(MGSplitTool* owner);

	MGSplitTool* state_owner(){
		return static_cast<MGSplitTool*>(get_owner_command());
	}
	const MGSplitTool* state_owner()const{
		return static_cast<const MGSplitTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);

private:
	void prompt_message()const;
};

#endif // !defined(AFX_SPLITTOOL_H__3E14647F_E042_4C50_B1A8_BE5A16BE2FFE__INCLUDED_)
 