/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/**
 * @file EditRebuildTool.h
 * @brief MGRebuildTool NX̃C^[tFCX
 */
#if !defined(AFX_EDITREBUILDTOOL_H__97192629_FE38_4CF7_A6E9_5A5DC85850AE__INCLUDED_)
#define AFX_EDITREBUILDTOOL_H__97192629_FE38_4CF7_A6E9_5A5DC85850AE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGRebuildTool RebuildTool.h CurveCmd/MGRebuildTool.h
///
/// Rebuilds a curve with specified degree and tolerance.
/// The knots of the resulting curve will be more or less evenly spaced. 
class MGRebuildTool:public MGSelectState{

public:
	explicit MGRebuildTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
	);
	MGAbstractGel target()const{return m_target_selected;};
	MGCurve* curve(){return m_curve;};
	MGLBRep* lbrep(){return m_lbrep;};
	MGRLBRep* rlbrep(){return m_rlbrep;};
	MGFace* face(){return m_face;};
	MGSurface* surface(){return m_surface;};
	MGSBRep* sbrep(){return m_sbrep;};
	MGRSBRep* rsbrep(){return m_rsbrep;};

private:
	MGAbstractGel m_target_to_select; ///< Kind of the target objects to rebuild.
		///< mgAll_Object, mgAll_FSurface, mgAll_Curve, mgAll_Surface, or mgAll_Face.
	MGAbstractGel m_target_selected;///<Kind of the target objects selected.
						///< mgAll_Curve,mgAll_Surface, or mgAll_Face.
	MGPickObject m_object; ///< Target objects selectd.
	MGCurve* m_curve;///If m_target_selected is MGCurve, the pointer will be set. 
	MGLBRep* m_lbrep;///If m_target_selected is MGLBRep, the pointer will be set. 
	MGRLBRep* m_rlbrep;///If m_target_selected is MGRLBRep, the pointer will be set.

	MGFace* m_face;///If m_target_selected is MGFace, the pointer will be set.
	/// m_surface, m_sbrep, and m_rsbrep are also set if m_face!=0.
	MGSurface* m_surface;///If m_target_selected is MGSurface or MGFace, the pointer will be set. 
	MGSBRep* m_sbrep;///If m_target_selected or m_face's base surface is MGSBRep , the pointer will be set. 
	MGRSBRep* m_rsbrep;///If m_target_selected or m_face's base surface is MGRSBRep , the pointer will be set. 

	///Select the target objects from the current objects into m_target_objects.
	///Function's return value is true if some are selected, false if none.
	bool select_objects(const MGPickObjects& objs);

	///Perform the rebuild process.
	///Function's return value is true if process was done, false if canceled.
	bool calculate();

	///Rebuild
	bool rebuild_curve();
	bool rebuild_surface();
	bool rebuild_face();
};

#endif // !defined(AFX_EDITREBUILDTOOL_H__97192629_FE38_4CF7_A6E9_5A5DC85850AE__INCLUDED_)
