/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// JoinTool.h: MGJoinTool NX̃C^[tFCX

#if !defined(AFX_JOINTOOL_H__34BFF921_6967_402D_8731_2CC043EED528__INCLUDED_)
#define AFX_JOINTOOL_H__34BFF921_6967_402D_8731_2CC043EED528__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"

// class MGJoinTool
//
// Joins objects as a single object.
class MGJoinTool : public MGCommandStateOwner{
public:
	explicit MGJoinTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandCanceled(UINT nIDS);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);

private:
	bool calculate();
	MGSelectState* check_current(const MGPickObject& po);

	// m_curve.get() Ԃ
	MGCompositeCurve* curve(){ return m_curve.get();}
	const MGCompositeCurve* curve() const{ return m_curve.get();}

	// m_shell.get() Ԃ
	MGShell* shell(){ return m_shell.get();}
	const MGShell* shell() const{ return m_shell.get();}

	//Function's return value is the manifold dimension of the kernel.
	int MakeSeed(const MGPickObject& po); // picked at first

	MGPickObjects m_target;	//Joined objects will be append. These are used to replance with
							//the joined object.
	std::unique_ptr<MGCompositeCurve> m_curve; // join 삪Ȑ̂ƂɎgp
	std::unique_ptr<MGShell>          m_shell; // join 삪Ȗʂ̂ƂɎgp

	friend class MGJoinSSeed;
	friend class MGJoinSCurve;
	friend class MGJoinSSurf;
};

// class MGJoinSSeed
//
// joinR}h̍ŏ̃IuWFNgIB
class MGJoinSSeed : public MGSelectState{
public:
	MGJoinSSeed(MGJoinTool* owner);

	MGJoinTool* state_owner(){
		return static_cast<MGJoinTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnSelected(
	fugenView* window,//The fugenView pointer where point input event took place.
	MGPickObjects&	objs,	//selected objects at this selection operation.
	MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
	);
};

// class MGJoinSCurve
//
// CompositeCurveR[Xstate
class MGJoinSCurve : public MGSelectState{
public:
	MGJoinSCurve(MGJoinTool* owner);

	MGJoinTool* state_owner(){
		return static_cast<MGJoinTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnSelected(
	fugenView* window,//The fugenView pointer where point input event took place.
	MGPickObjects&	objs,	//selected objects at this selection operation.
	MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
	);
};

// class MGJoinSSurf
//
// ShellR[Xstate
class MGJoinSSurf : public MGSelectState{
public:
	MGJoinSSurf(MGJoinTool* owner);

	MGJoinTool* state_owner(){
		return static_cast<MGJoinTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnSelected(
	fugenView* window,//The fugenView pointer where point input event took place.
	MGPickObjects&	objs,	//selected objects at this selection operation.
	MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
	);
};

#endif // !defined(AFX_JOINTOOL_H__34BFF921_6967_402D_8731_2CC043EED528__INCLUDED_)
