/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// ExplodeTool.h: MGExplodeTool NX̃C^[tFCX

#if !defined(AFX_EXPLODETOOL_H__B1550CEC_5169_446C_B8CF_5B8C6669CAA4__INCLUDED_)
#define AFX_EXPLODETOOL_H__B1550CEC_5169_446C_B8CF_5B8C6669CAA4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

// class MGExplodeTool
//
// Explodes (unjoins) an object.
// You can explode a shell into separate faces. 
// You can explode a composite curve into curve segments and polyline into line segments.
class MGExplodeTool : public MGSelectState{
public:
	explicit MGExplodeTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnSelected(
	fugenView* window,//The fugenView pointer where point input event took place.
	MGPickObjects&	objs,	//selected objects at this selection operation.
	MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
	);

private:
	bool calculate(MGPickObject& obj);

	UINT m_nIDS;  // error message
};

#endif // !defined(AFX_EXPLODETOOL_H__B1550CEC_5169_446C_B8CF_5B8C6669CAA4__INCLUDED_)
