/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file EditAttribTool.cpp
 * @brief EditAttribTool.h ̎
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "GLAttribSheet.h"
#include "EditCmd/EditAttribTool.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGAttribTool

MGAttribTool::MGAttribTool(fugenDoc* pDoc)
: MGCommandStateOwner(pDoc, ID_EDIT_ATTRIB){
}

MGCommandBase* MGAttribTool::initial_clone(fugenDoc* pDoc)const{
	return new MGAttribTool(pDoc);
}

bool MGAttribTool::initiate_tool(){
	MGCommandStateOwner::initiate_tool();

	// ɉIuWFNgIĂꍇ́A
	// CɃt@Cۑ_CAÕXebv܂ŃXLbvB
	const MGPickObjects& selection = current_objects();
	if(selection.empty()){
		set_child_current_command(new MGAttribSelectState(this));
	}
	else{
		SetTarget(selection);
		set_child_current_command(new MGAttribEditState(this));
	}

	return false;
}

MGPickObjects& MGAttribTool::GetTarget(){
	return m_target;
}

void MGAttribTool::SetTarget(const MGPickObjects& target){
	m_target = target;
	document()->UpdateAllViews(0); // PɃtbVB
}

// MGAttribSelectState

MGAttribSelectState::MGAttribSelectState(MGAttribTool* pOwner)
: MGSelectState(pOwner, MULTIPLE_SELECT){
}

bool MGAttribSelectState::initiate_tool(){
	MGSelectState::initiate_tool();

	// INAB
	clear_pick_object();

	SetStatusMessage(IDS_PROMPT_EDIT_MULTI);

	return false;
}

bool MGAttribSelectState::OnKeyDown(fugenView* pView, UINT nChar,UINT nRepCnt, UINT nFlags){
	switch(nChar){
	case VK_RETURN:{
			// ^[QbgZbgĕҏWԂɑJڂB
			MGAttribTool* pOwner = state_owner();
			pOwner->SetTarget(current_objects());
			set_sibling_next_command(new MGAttribEditState(pOwner));
		}
		return false;
	default:
		break;
	}

	return MGSelectState::OnKeyDown(pView, nChar, nRepCnt, nFlags);
}

// MGAttribEditState

MGAttribEditState::MGAttribEditState(MGAttribTool* pOwner)
: MGCommandBase(pOwner){
}

bool MGAttribEditState::initiate_tool(){
	MGCommandBase::initiate_tool();
	SetStatusMessage(IDS_PROMPT_EDIT_ATTRIB);
	return execute();
}

bool MGAttribEditState::execute(){
	MGAttribTool* pOwner = state_owner();

	CGLAttribSheet sheet(IDS_CAPTION_ATTRIB);
	sheet.InitAttrib(pOwner->GetTarget(),document());

	if(IDOK == sheet.DoModal()){
		sheet.ModifyAttrib(pOwner->GetTarget(), document());
		return OnCommandEnd(1);
	}

	return OnCommandEnd(3);
}
