#include "stdafx.h"
#include "mg/LBRep.h"
#include "mg/PickObject.h"
#include "Calc/curve.h"
#include "Calc/mgcalc.h"
#include "GLInputNumberDlg.h"
#include "fugenView.h"
#include "Misc/UserPreference.h"
#include "CurveCmd/SplineCurveUpdateTangentTool.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// ڃxNgύXR}h

// MGSplineCurveUpdateTangentTool
MGSplineCurveUpdateTangentTool::MGSplineCurveUpdateTangentTool(fugenDoc* pDoc)
: MGCommandStateOwner(pDoc, ID_CURVE_SPLINE_MOVE_POINT){
}

MGCommandBase* MGSplineCurveUpdateTangentTool::initial_clone(fugenDoc* pDoc)const{
	return new MGSplineCurveUpdateTangentTool(pDoc);
}

bool MGSplineCurveUpdateTangentTool::initiate_tool(){
	MGCommandStateOwner::initiate_tool();

	// sbNĂꍇ́AxNA
	clear_pick_object();

	// Ȑ(mgAll_LBRep)̑IX^[g
	set_child_current_command(new MGSplineCurveSelectTarget(this));

	return false;
}

// MGSplineCurveSelectTarget
MGSplineCurveSelectTarget::MGSplineCurveSelectTarget(MGSplineCurveUpdateTangentTool* owner)
: MGSelectState(owner, MGSelectState::SINGLE_SELECT, mgAll_LBRep){
}

bool MGSplineCurveSelectTarget::initiate_tool(){
	MGSelectState::initiate_tool();

	SetStatusMessage(IDS_PROMPT_CURVE);
	return false;
}

bool MGSplineCurveSelectTarget::OnSelected(
	fugenView* window,//The fugenView pointer where point input event took place.
	MGPickObjects& objs,	//selected objects at this selection operation.
	MGPickObjects& unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
){
	MGSplineCurveUpdateTangentTool* owner = state_owner();

	// IꂽIuWFNg擾
	MGPickObject& obj = owner->m_pickedCurve = objs.front();

	// targetCurve̎擾
	owner->m_targetCurve = static_cast<MGLBRep*>(obj.leaf_object());
	const MGLBRep& lb = *owner->m_targetCurve;

	// _̎擾
	size_t nm = lb.bdim();

	// _̐2̏ꍇ́AR}hLZ
	if (nm == 2) {
		return OnCommandEnd(IDS_ERROR_SPLINE_CURVE_TO_STRAIGHT);
	}

	// Iꂽ_W̃p[^l(t_selctied)擾
	const MGPosition& tt = obj.parameter();
	double t_selctied = tt[0];

	// n_ƏI_̃p[^擾AIꂽ_n_ƏI_̂ǂ炪߂𔻒
	double ts = lb.param_s(), te = lb.param_e();
	owner->m_target_is_start = (t_selctied - ts) <= (te - t_selctied);

	// m_curvetargetCurveRs[
	owner->m_curve = std::unique_ptr<MGLBRep>(new MGLBRep(lb));

	// state(_w)֐i 
	set_sibling_next_command(new MGSplineCurveUpdateTangent(state_owner()));

	return false;
}

// MGSplineCurveUpdateTangent
MGSplineCurveUpdateTangent::MGSplineCurveUpdateTangent(MGSplineCurveUpdateTangentTool* owner)
: MGLocateState(owner,
LOCK_SNAP_ATTRIB,//Prohibit to update snap attrib
NO_RUBBER,POINTLINE_IPDRAW){
}

bool MGSplineCurveUpdateTangent::initiate_tool(){
	MGLocateState::initiate_tool();

	SetStatusMessage(IDS_PROMPT_UPDATE_TANGENT_1);
	return false;
}

void MGSplineCurveUpdateTangent::do_make_temporary_display(mgSysGL& sgl,fugenView* pView){
	MGSplineCurveUpdateTangentTool* owner = state_owner();
	MGBPointSeq& bp = owner->m_curve->line_bcoef();

	// n_ƏI_̂ǂ炪߂
	if(owner->m_target_is_start){
		// _ύX
		bp.store_at(1, cursor());
	}else{
		// I_1O̍W
		int nm2 = bp.length()-2;
		// _ύX
		bp.store_at(nm2, cursor());
	}

	// n_Ƃ̎̓_
	MGPosition P0(bp(1)), P1(bp(0));
	// n_̉_
	MGPosition P2(2 * bp(0)(0) - bp(1)(0), 2 * bp(0)(1) - bp(1)(1), 2 * bp(0)(2) - bp(1)(2));

	int n = bp.length();
	// I_Ƃ̑O̓_
	MGPosition Pnm0(bp(n-1)), Pnm1(bp(n-2));
	// I_̉_
	MGPosition Pnm2(2 * bp(n-1)(0) - bp(n-2)(0), 2 * bp(n-1)(1) - bp(n-2)(1), 2 * bp(n-1)(2) - bp(n-2)(2));

	// ɐF(Ƃ肠MGColor::Blue)
	MGColor::get_instance(MGColor::Blue).exec(sgl);
	// ڃxNg`
	sgl.drawStraight(P0, P1);
	sgl.drawStraight(P0, P2); // n_Ǝn_̉_񂾒
	sgl.drawStraight(Pnm0, Pnm1);
	sgl.drawStraight(Pnm0, Pnm2); // I_ƏI_̉_񂾒
	// ɐF
	MGColor::get_instance(MGColor::SpringGreen).exec(sgl);
	// Ȑ`
	owner->m_curve->drawWire(sgl);
}

bool MGSplineCurveUpdateTangent::OnLocated(const MGLocateInfo& info){
	MGSplineCurveUpdateTangentTool* owner = state_owner();

	MGGelPosition replaceObj(owner->m_pickedCurve.bottom_group(), owner->m_curve.release());
	// ÂIuWFNgƐVIuWFNg̓ւ
	replace(owner->m_pickedCurve, replaceObj);
	return OnCommandEnd(1);
}

bool MGSplineCurveUpdateTangent::OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags){
	MGSplineCurveUpdateTangentTool* owner = state_owner();

	switch(nChar){
	case 'c':
	case 'C':
		// ύXn_ƏI_ς
		owner->m_target_is_start = !owner->m_target_is_start;

		// n_I_ύXɃJ[\̒l_ɂȂĂ܂Ă̂ŁA
		// n_I_ύX́Am_curvexIꂽȐɖ߂ 
		owner->m_curve = std::unique_ptr<MGLBRep>(new MGLBRep(*owner->m_targetCurve));
		break;
	default:;
	}
	return MGLocateState::OnKeyDown(pView, nChar, nRepCnt, nFlags);
}
