/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file SplineCPointTool.h
 * @brief MGSplineCPointTool NX̃C^[tFCX
 */
#if !defined(AFX_SPLINECPOINTTOOL_H__1DDFF931_BB1A_4112_B57C_4BB069442872__INCLUDED_)
#define AFX_SPLINECPOINTTOOL_H__1DDFF931_BB1A_4112_B57C_4BB069442872__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGSplineCPointTool SplineCPointTool.h "CurveCmd/SplineCPointTool.h"
///
/// Creates a curve by control points.
class MGSplineCPointTool : public MGLocateState{
public:
	explicit MGSplineCPointTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	bool calculate();
	void prompt_message() const;
	UINT m_nIDS; ///< error message

	int  m_nDegree; ///< Ȑ̎ Ȃ킿 order - 1.
	bool m_bClose; ///< Ȑ邩ǂ
	bool m_bSharp; ///< Ȑ̂ł΁AnI_̓LNɂ邩
};

#endif // !defined(AFX_SPLINECPOINTTOOL_H__1DDFF931_BB1A_4112_B57C_4BB069442872__INCLUDED_)
