/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file Rectangle.cpp
 * @brief MGRectangleTool NX̃Cve[V
 */
#include "stdafx.h"
#include "fugen.h"
#include "fugenDoc.h"
#include "CurveCmd/Rectangle.h"
#include "CurveCmd/RectCorner.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGRectangleTool

MGRectangleTool::MGRectangleTool(fugenDoc* pDoc)
	 : MGCommandStateOwner(
		 pDoc,
		 ID_CURVE_RECT_CC)
{
}

MGCommandBase* MGRectangleTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGRectangleTool(pDoc);
}

bool MGRectangleTool::initiate_tool(){
	MGCommandStateOwner::initiate_tool();
	set_child_current_command(new MGRectCornerTool(this));
	return false;
}
