/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file RectVertical.h
 * @brief MGRectVerticalTool NX̃C^[tFCX
 */
#if !defined(AFX_RECTVERTICAL_H__21DBFC07_AE76_41AD_B6D3_837E26CB0D0C__INCLUDED_)
#define AFX_RECTVERTICAL_H__21DBFC07_AE76_41AD_B6D3_837E26CB0D0C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"
#include "Calc/rect.h"

class MGCommandStateOwner;

/// @class MGRectVerticalTool RectVertical.h "CurveCmd/RectVertical.h"
///
/// Creates a rectangle from two corner points.
class MGRectVerticalTool : public MGLocateState{
public:
	explicit MGRectVerticalTool(MGCommandStateOwner* owner);
	explicit MGRectVerticalTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);
	
private:
	void make_rect(const MGPosition& posLas);///<make m_rect from input 0,1 data and posLas.
	void make_round_rect(
		const MGPosition& posLast);///<make m_round_rect from m_rect and poslLast.
	void make_round_rect(double radius);///<make m_round_rect from m_rect and radius.
	void prompt_message() const;

	mgcalc::MGRect m_rect; ///< ꎞ`p
	mgcalc::MGRoundRect m_round_rect; ///< ꎞ`p
	double m_dRadius; ///< EhR[i[̔a
	bool m_bRound;  ///< `̊pۂ邩
};

#endif // !defined(AFX_RECTVERTICAL_H__21DBFC07_AE76_41AD_B6D3_837E26CB0D0C__INCLUDED_)
