/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file Rect3Point.h
 * @brief MGRect3PointTool NX̃C^[tFCX
 */
#if !defined(AFX_RECT3POINT_H__4D607FD9_0149_4E13_AFFB_C6A449658A99__INCLUDED_)
#define AFX_RECT3POINT_H__4D607FD9_0149_4E13_AFFB_C6A449658A99__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"
#include "Calc/rect.h"

class MGCommandStateOwner;

/// @class MGRect3PointTool Rect3Point.h "CurveCmd/Rect3Point.h"
///
/// Creates a rectangle from two corner points.
class MGRect3PointTool : public MGLocateState{
public:
	explicit MGRect3PointTool(MGCommandStateOwner* owner);
	explicit MGRect3PointTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	bool calculate();
	void prompt_message() const;

	mgcalc::MGRect m_rect; ///< ꎞ`p
	mgcalc::MGRoundRect m_round_rect; ///< ꎞ`p
	double m_dRadius; ///< EhR[i[̔a
	bool m_bRound; ///< `̊pۂ邩
};

#endif // !defined(AFX_RECT3POINT_H__4D607FD9_0149_4E13_AFFB_C6A449658A99__INCLUDED_)
