/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file PolygonEdge.h
 * @brief MGPolygonEdgeTool NX̃C^[tFCX
 */
#if !defined(AFX_POLYGONEDGE_H__6AFB3519_1DB7_42E2_9FE2_A890C49D89D9__INCLUDED_)
#define AFX_POLYGONEDGE_H__6AFB3519_1DB7_42E2_9FE2_A890C49D89D9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"
#include "mg/Curve.h"

/// @class MGPolygonEdgeTool PolygonEdge.h "CurveCmd/PolygonEdge.h"
///
/// GbWw肵Đp`𐶐R}h
class MGPolygonEdgeTool : public MGLocateState{
public:
	explicit MGPolygonEdgeTool(MGCommandStateOwner* owner);
	explicit MGPolygonEdgeTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	bool calculate();
	void prompt_message() const;

	std::unique_ptr<MGCurve> m_polygon; ///< ꎞ`pIuWFNg
	int m_N; ///<  N p`
	UINT m_nIDS; ///< error message
	bool m_bVertical; ///< CPlaneɐȖʂʂ悤ɂ邩
	bool m_bFlip; ///< @̔]
};

#endif // !defined(AFX_POLYGONEDGE_H__6AFB3519_1DB7_42E2_9FE2_A890C49D89D9__INCLUDED_)
