/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file Polygon.cpp
 * @brief MGPolygonTool NX̃Cve[V
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "CurveCmd/Polygon.h"
#include "CurveCmd/PolygonVertex.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGPolygonTool

MGPolygonTool::MGPolygonTool(fugenDoc* pDoc)
	 : MGCommandStateOwner(
		 pDoc,
		 ID_CURVE_POLYGON)
{
}

MGCommandBase* MGPolygonTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGPolygonTool(pDoc);
}

bool MGPolygonTool::initiate_tool(){
	MGCommandStateOwner::initiate_tool();
	set_child_current_command(new MGPolygonVertexTool(this));
	return false;
}
