/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file PointSingleTool.cpp
 * @brief MGPointSingleTool NX̃Cve[V
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "CurveCmd/PointSingleTool.h"
#include "mg/Point.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGPointSingleTool

MGPointSingleTool::MGPointSingleTool(fugenDoc* pDoc)
: MGLocateState(pDoc,ID_CURVE_POINT_SINGLE,NO_RUBBER,POINT_IPDRAW){
}

MGCommandBase* MGPointSingleTool::initial_clone(fugenDoc* pDoc)const{
	return new MGPointSingleTool(pDoc);
}

bool MGPointSingleTool::initiate_tool(){
	MGLocateState::initiate_tool();

	// ŏ̃bZ[W
	SetStatusMessage(IDS_PROMPT_POSITION);
	return false;
}

bool MGPointSingleTool::OnLocated(const MGLocateInfo& info){
	ASSERT(locates().size() == 1);
	add_object_to_current_group(new MGPoint(info.point_world()));
	return OnCommandEnd(1);
}
