/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file PointFromCurveLength.h
 * @brief MGPointFromCurveLengthTool NX̃C^[tFCX
 */
#if !defined(AFX_POINTFROMCURVELENGTH_H__73566EA7_F5A6_4DD9_95E0_558A6A3FEC87__INCLUDED_)
#define AFX_POINTFROMCURVELENGTH_H__73566EA7_F5A6_4DD9_95E0_558A6A3FEC87__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGPointFromCurveLengthTool PointFromCurveLength.h "CurveCmd/PointFromCurveLength.h"
///
/// Divides a curve by length and creates point objects on a curve
/// starting from the natural start of the curve.
class MGPointFromCurveLengthTool : public MGSelectState{
public:
	explicit MGPointFromCurveLengthTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);

private:
	bool calculate();
	bool input_param();
	void prompt_message() const;
	
	double        m_dLength;  // ̒

	// _o߂ɃsbNꂽȐׂ
	MGPickObjects m_curve;
};

#endif // !defined(AFX_POINTFROMCURVELENGTH_H__73566EA7_F5A6_4DD9_95E0_558A6A3FEC87__INCLUDED_)
