/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file PointFromCurveDivide.h
 * @brief MGPointFromCurveDivideTool NX̃C^[tFCX
 */
#if !defined(AFX_POINTFROMCURVEDIVIDE_H__95A45258_D8F2_4198_9B7A_9CF5CE9B4033__INCLUDED_)
#define AFX_POINTFROMCURVEDIVIDE_H__95A45258_D8F2_4198_9B7A_9CF5CE9B4033__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGPointFromCurveDivideTool PointFromCurveDivide.h "CurveCmd/PointFromCurveDivide.h"
///
/// Divides a curve by number of segments and creates point objects
/// evenly spaced along the curve and one at each end of the curve. 
class MGPointFromCurveDivideTool : public MGSelectState{
public:
	explicit MGPointFromCurveDivideTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);

private:
	bool calculate();
	bool input_param();
	void prompt_message() const;
	
	int           m_nDivide; // 

	// _o߂ɃsbNꂽȐׂ
	MGPickObjects m_curve;
};

#endif // !defined(AFX_POINTFROMCURVEDIVIDE_H__95A45258_D8F2_4198_9B7A_9CF5CE9B4033__INCLUDED_)
