/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file PointEndTool.h
 * @brief MGPointEndTool NX̃C^[tFCX
 */
#if !defined(AFX_ENDPOINTTOOL_H__EFFC1948_6B1D_4375_9483_5E9B5B64FCBF__INCLUDED_)
#define AFX_ENDPOINTTOOL_H__EFFC1948_6B1D_4375_9483_5E9B5B64FCBF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"

/// @class MGPointEndTool PointEndTool.h "CurveCmd/PointEndTool.h"
///
/// Creates a point at the endpoint of a curve.
class MGPointEndTool : public MGSelectState{
public:
	MGPointEndTool(fugenDoc* pDoc, bool bExtractStart);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	
private:
	bool calculate();
	void prompt_message() const;

	MGPickObjects m_curve; // IꂽׂĂ̋Ȑ
	UINT          m_nIDS;  // error message

	// n_𒊏o邩AI_𒊏o邩
	bool          m_bExtractStart;
};

MGCommandBase* CreatePointEndTool(fugenDoc* pDoc, UINT nCmdId);

#endif // !defined(AFX_ENDPOINTTOOL_H__EFFC1948_6B1D_4375_9483_5E9B5B64FCBF__INCLUDED_)
