/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file LineNormal.h
 * @brief MGLineNormalTool NX̃C^[tFCX
 */
#if !defined(AFX_LINENORMAL_H__0E507ADA_25C8_45CB_BBEE_D76689CC0A70__INCLUDED_)
#define AFX_LINENORMAL_H__0E507ADA_25C8_45CB_BBEE_D76689CC0A70__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"
#include "Common/LocateOnObjects.h"
#include "mg/Straight.h"

/// @class MGLineNormalTool LineNormal.h "CurveCmd/LineNormal.h"
///
/// Creates a line normal to a surface/face.
class MGLineNormalTool : public MGCommandStateOwner{
public:
	explicit MGLineNormalTool(fugenDoc* pDoc);
	explicit MGLineNormalTool(MGCommandStateOwner* owner);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);

private:

	//make a line whose end is P's closest point against m_baseline.
	std::unique_ptr<MGCurve>  make_line(const MGPosition& P);

	const MGFSurface* m_surf; ///< ΏۂƂȂȖ
	std::unique_ptr<MGStraight> m_baseline; ///< @钼

	// IvV
	bool m_bBoth; ///< 1_ڂ̓͂̈Ӗ (true _; false n_)

	friend class MGLineNormalSSurf;
	friend class MGLineNormalIPoint;
};

/// @class MGLineNormalSSurf
///
/// ȖʂЂƂI
class MGLineNormalSSurf : public MGSelectState{
public:
	MGLineNormalSSurf(MGLineNormalTool* owner);

	MGLineNormalTool* state_owner(){
		return static_cast<MGLineNormalTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
	);
};

/// @class MGLineNormalIPoint
///
/// Ȗʏ̓_Ɩ@̏I_͂
class MGLineNormalIPoint : public MGLocateOnObjects{
public:
	MGLineNormalIPoint(MGLineNormalTool* owner);
	MGLineNormalTool* state_owner(){
		return static_cast<MGLineNormalTool*>(get_owner_command());
	}
	const MGLineNormalTool* state_owner() const{
		return static_cast<const MGLineNormalTool*>(get_owner_command());
	}

	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);

private:
	void prompt_message() const;
};

#endif // !defined(AFX_LINENORMAL_H__0E507ADA_25C8_45CB_BBEE_D76689CC0A70__INCLUDED_)
