/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

/**
 * @file LineAngled.h
 * @brief MGLineAngledTool NX̃C^[tFCX
 */
#if !defined(AFX_LINEANGLED_H__8906191C_D748_464E_9A83_281EFB57CCE3__INCLUDED_)
#define AFX_LINEANGLED_H__8906191C_D748_464E_9A83_281EFB57CCE3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGLineAngledTool LineAngled.h "CurveCmd/LineAngled.h"
///
/// Creates a line at a specified angle from another line.
class MGLineAngledTool : public MGLocateState{
public:
	explicit MGLineAngledTool(fugenDoc*);
	explicit MGLineAngledTool(MGCommandStateOwner* owner);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);

	/////////////////functions for draw_temporary()////////////
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView*);

private:
	bool make_line();//make the target line and add the line to the document.
	void prompt_message() const;//Prompt the appropriate message on the status message area.
	
	MGVector m_rho; //the vector whose angle to the base line is m_rAngle.
			//m_line is made along this vector from the starting position linfos[0].

	MGPosition m_baseLineEnd;//locates()[0] to m_baseLineEnd is the baase line.
	double m_dAngle; // px to the base line in degree
	bool   m_bBoth : 1;  // nR}hʂ̗IvV
};

#endif // !defined(AFX_LINEANGLED_H__8906191C_D748_464E_9A83_281EFB57CCE3__INCLUDED_)
