/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

/**
 * @file Line4Point.cpp
 * @brief MGLine4PointTool NX̃Cve[V
 */
#include "stdafx.h"
#include "mg/Straight.h"
#include "Calc/line.h"
#include "Calc/mgcalc.h"
#include "fugenView.h"
#include "Common/CommandStateOwner.h"
#include "Misc/UserPreference.h"
#include "CurveCmd/Line4Point.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGLine4PointTool

MGLine4PointTool::MGLine4PointTool(fugenDoc* pDoc)
:MGLocateState(pDoc,ID_CURVE_LINE_4PNT,LINE_RUBBER,POINTLINE_IPDRAW),m_bBoth(false){
}

MGLine4PointTool::MGLine4PointTool(MGCommandStateOwner* owner)
:MGLocateState(owner,UNLOCK_SNAP_ATTRIB,LINE_RUBBER,POINTLINE_IPDRAW),m_bBoth(false){
}

MGCommandBase* MGLine4PointTool::initial_clone(fugenDoc* pDoc)const{
	return new MGLine4PointTool(pDoc);
}

bool MGLine4PointTool::initiate_tool(){
	MGLocateState::initiate_tool();
	const UserPreference& pref = UserPreference::getInstance();
	m_bBoth = pref.GetBoolValue(upv_Curve_Line4Point_Both);
	return false;
}

bool MGLine4PointTool::terminate_tool(bool cancel){
	UserPreference& pref = UserPreference::getInstance();
	pref.SetBoolValue(upv_Curve_Line4Point_Both, m_bBoth);

	return MGLocateState::terminate_tool(cancel);
}

bool MGLine4PointTool::make_object(){
	const LInfoVec& linfos=locates();	
	ASSERT(locates().size() == 4);
	const MGPosition& P2=linfos[2]->point_world();
	const MGPosition& P3=linfos[3]->point_world();

	std::unique_ptr<MGCurve> line = mgcalc::create_line(P2, P3, m_bBoth);
	// hLgύX
	add_object_to_current_group(line.release());	
	return true;
}

bool MGLine4PointTool::OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags){
	switch(nChar){
	case 'b':
	case 'B':
		m_bBoth ^= true;
		break;
	default:;
	}
	return MGLocateState::OnKeyDown(pView, nChar, nRepCnt, nFlags);
}

bool MGLine4PointTool::OnLocated(const MGLocateInfo& info){
	const LInfoVec& linfos=locates();
	size_t np=linfos.size();
	MGCursorRestriction& snap=cursorRestriction();
	switch(np){
	case 1:
		disable_AETPmode();
		break;
	case 2: // 2,3 ͋
	case 3:	{// }EX|C^
		const MGPosition& P0=linfos[0]->point_world();
		const MGPosition& P1=linfos[1]->point_world();	
		setTabRestrictionToProhibitUpdate(P0,P1);
		if(np==3){
			setDrawerLWidthRubber(2.f);
			setDrawerColorRubber(MGColor::get_instance(MGColor::SpringGreen));
		}

		}
		break;
	}
	if(linfos.size()<4){
		return false;
	}
	make_object();
	disable_AETPmode();
	return OnCommandEnd(1); // R}hI
}

void MGLine4PointTool::prompt_message() const{
	switch(locates().size()){
	case 0:
		SetStatusMessage(IDS_PROMPT_BASELINE_START);
		break;
	case 1:
		SetStatusMessage(IDS_PROMPT_BASELINE_END);
		break;
	case 2:
		SetStatusMessage(IDS_PROMPT_LINE_START);
		break;
	case 3:
		{
			CString strYesNo;
			strYesNo.LoadString(m_bBoth ? IDS_YES : IDS_NO);
			SetStatusMessage(IDS_PROMPT_LINE_END, strYesNo);
		}
		break;
	}
}
