/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file ExtendLineToPnt.h
 * @brief MGExtendLineToPnt NX̃C^[tFCX
 */
#if !defined(AFX_CURVEEXTLINETOPNT_H__BBAA7C0B_B962_4E90_8915_A3AE1CB7895F__INCLUDED_)
#define AFX_CURVEEXTLINETOPNT_H__BBAA7C0B_B962_4E90_8915_A3AE1CB7895F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGExtendLineToPnt ExtendLineToPnt.h CurveCmd/ExtendLineToPnt.h
///
/// Extends a curve to given point with straight line.
class MGExtendLineToPnt : public MGLocateState{
public:
	explicit MGExtendLineToPnt(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView*, UINT, UINT, UINT);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	bool calculate();
	void prompt_message() const;
	UINT m_nIDS; ///< G[bZ[W
	// IvV
	bool m_bBoth; ///< [_𐶐̎n_ł͂Ȃ_Ƃ邩ǂ
};

#endif // !defined(AFX_CURVEEXTLINETOPNT_H__BBAA7C0B_B962_4E90_8915_A3AE1CB7895F__INCLUDED_)
