/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

/**
 * @file ExtendArcToPnt.h
 * @brief MGExtendArcToPnt NX̃C^[tFCX
 */
#if !defined(AFX_CURVEEXTARCTOPNT_H__3F5225AA_6EC4_4DDC_B7DF_B3B68DF8770B__INCLUDED_)
#define AFX_CURVEEXTARCTOPNT_H__3F5225AA_6EC4_4DDC_B7DF_B3B68DF8770B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"
#include "mg/Ellipse.h"

/// @class MGExtendArcToPnt ExtendArcToPnt.h CurveCmd/ExtendArcToPnt.h
///
/// Extends a curve to given point with arc.
class MGExtendArcToPnt : public MGLocateState{
public:
	explicit MGExtendArcToPnt(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnLocated(const MGLocateInfo& info);
	std::unique_ptr<MGEllipse> make_ellipse(const MGPosition& to_point);

	/////////////////functions for draw_temporary()////////////
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	bool calculate();
	void prompt_message() const;
	UINT m_nIDS; ///< G[bZ[W
};

#endif // !defined(AFX_CURVEEXTARCTOPNT_H__3F5225AA_6EC4_4DDC_B7DF_B3B68DF8770B__INCLUDED_)
