/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file ElpsFociTool.h
 * @brief MGElpsFociTool NX̃C^[tFCX
 */
#if !defined(AFX_ELPSFOCITOOL_H__DB5519C6_CDE9_484D_8B18_BF276B0CF4DC__INCLUDED_)
#define AFX_ELPSFOCITOOL_H__DB5519C6_CDE9_484D_8B18_BF276B0CF4DC__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"
#include "mg/Ellipse.h"

class MGCommandStateOwner;

/// @class MGElpsFociTool ElpsFociTool.h "CurveCmd/ElpsFociTool.h"
///
/// Creates an ellipse from focus points.
class MGElpsFociTool : public MGLocateState{
public:
	explicit MGElpsFociTool(fugenDoc* pDoc);
	explicit MGElpsFociTool(MGCommandStateOwner* owner);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView*, UINT, UINT, UINT);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	void prompt_message() const;
	bool m_bMarkFoci; ///< œ_IuWFNgăhLgɒǉ邩ǂ
};

#endif // !defined(AFX_ELPSFOCITOOL_H__DB5519C6_CDE9_484D_8B18_BF276B0CF4DC__INCLUDED_)
