/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file ElpsCorner.cpp
 * @brief MGElpsCornerTool NX̃Cve[V
 */
#include "stdafx.h"
#include "Calc/ellipse.h"
#include "Calc/mgcalc.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "Common/CommandStateOwner.h"
#include "CurveCmd/ElpsCorner.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGElpsCornerTool

MGElpsCornerTool::MGElpsCornerTool(fugenDoc* pDoc)
: MGLocateState(pDoc,ID_CURVE_ELLIPSE_CORNER,NO_RUBBER,POINT_IPDRAW),m_plane(0){
}

MGElpsCornerTool::MGElpsCornerTool(MGCommandStateOwner* owner)
: MGLocateState(owner, UNLOCK_SNAP_ATTRIB, NO_RUBBER, POINT_IPDRAW),
m_plane(0){
}

MGCommandBase* MGElpsCornerTool::initial_clone(fugenDoc* pDoc)const{
	return new MGElpsCornerTool(pDoc);
}

void MGElpsCornerTool::do_make_temporary_display(mgSysGL& sgl,fugenView* pView){
	const LInfoVec& linfos=locates();
	std::unique_ptr<MGEllipse> elps;
	MGPosition origin;
	if(!linfos.empty()){
		const MGPosition& P0=linfos[0]->point_world();
		elps=mgcalc::create_ellipse(*m_plane,P0,cursor());
		origin = (P0+cursor()) * .5;
	}

	if(elps.get()){
		MGColor::get_instance(MGColor::SpringGreen).exec(sgl);
		elps->drawWire(sgl);
		MGColor::get_instance(MGColor::Black).exec(sgl);
		sgl.drawPoint(linfos[0]->point_world());
		sgl.drawPoint(cursor());
		sgl.drawPoint(origin);
	}
}

bool MGElpsCornerTool::OnLocated(const MGLocateInfo& info){
	const LInfoVec& linfos=locates();
	size_t np = linfos.size();	
	if(np==1)
		m_plane = &info.window()->cplane().plane();

	if(np>=2){
		// vZJn
		const MGPosition& P0=linfos[0]->point_world();
		const MGPosition& P1=linfos[1]->point_world();
		
		// vZJn
		std::unique_ptr<MGEllipse> elps=mgcalc::create_ellipse(*m_plane,P0,P1);
		if(!elps.get()){
			return OnCommandEnd(IDS_FAIL_GENERATE_CURVE);
		}
		// hLgύX
		add_object_to_current_group(elps.release());
		return OnCommandEnd(1); // R}hI
	}
	return false;
}

void MGElpsCornerTool::prompt_message() const{
	if(locates().empty()){
		SetStatusMessage(IDS_PROMPT_ELLIPSE_CORNER_0);
	}else{
		SetStatusMessage(IDS_PROMPT_ELLIPSE_CORNER_1);
	}
}
