/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file ElpsCenAxesTool.h
 * @brief MGElpsCenAxesTool NX̃C^[tFCX
 */
#if !defined(AFX_ELPSCENAXESTOOL_H__BA3B3B9D_05AD_49BC_914B_E74BB54C80FD__INCLUDED_)
#define AFX_ELPSCENAXESTOOL_H__BA3B3B9D_05AD_49BC_914B_E74BB54C80FD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

class MGCommandStateOwner;

/// @class MGElpsCenAxesTool ElpsCenAxesTool.h CurveCmd/ElpsCenAxesTool.h
///
/// Creates an ellipse from the center point and the two axes.
class MGElpsCenAxesTool : public MGLocateState{
public:
	explicit MGElpsCenAxesTool(MGCommandStateOwner* owner);
	virtual bool OnKeyDown(fugenView*, UINT, UINT, UINT);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);
	
private:
	std::unique_ptr<MGEllipse> makeModle(const MGPosition& posLast);
	void prompt_message() const;
};

#endif // !defined(AFX_ELPSCENAXESTOOL_H__BA3B3B9D_05AD_49BC_914B_E74BB54C80FD__INCLUDED_)
