/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file ElpsAroundCurve.h
 * @brief MGElpsAroundCurveTool NX̃C^[tFCX
 */
#pragma once

#include "Common/LocateState.h"

class MGEllipse;

/// @class MGElpsAroundCurveTool ElpsAroundCurve.h "CurveCmd/ElpsAroundCurve.h"
///
/// ȉ~R}h̋Ȑ[hB
class MGElpsAroundCurveTool : public MGLocateState{
	MGVector m_normal;
	bool m_bNear; ///< NEAR Xibv̌X̏

public:
	explicit MGElpsAroundCurveTool(MGCommandStateOwner* owner);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	bool calculate();
	void prompt_message() const;
	MGEllipse* create_ellipse(const MGPosition& epos) const;
};
